/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc.syntax;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.annotation.CustomProcedure;
import org.neo4j.gds.doc.syntax.ProcedureLookup;

@ParametersAreNonnullByDefault
@Generated(from="ProcedureLookup.ProcedureSpec", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableProcedureSpec
implements ProcedureLookup.ProcedureSpec {
    private final String name;
    private final Class<?> resultType;
    private final List<String> argumentNames;
    private final CustomProcedure.Namespace namespace;

    private ImmutableProcedureSpec(String name, Class<?> resultType, Iterable<String> argumentNames, CustomProcedure.Namespace namespace) {
        this.name = Objects.requireNonNull(name, "name");
        this.resultType = Objects.requireNonNull(resultType, "resultType");
        this.argumentNames = ImmutableProcedureSpec.createUnmodifiableList(false, ImmutableProcedureSpec.createSafeList(argumentNames, true, false));
        this.namespace = Objects.requireNonNull(namespace, "namespace");
    }

    private ImmutableProcedureSpec(ImmutableProcedureSpec original, String name, Class<?> resultType, List<String> argumentNames, CustomProcedure.Namespace namespace) {
        this.name = name;
        this.resultType = resultType;
        this.argumentNames = argumentNames;
        this.namespace = namespace;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Class<?> resultType() {
        return this.resultType;
    }

    @Override
    public List<String> argumentNames() {
        return this.argumentNames;
    }

    @Override
    public CustomProcedure.Namespace namespace() {
        return this.namespace;
    }

    public final ImmutableProcedureSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableProcedureSpec(this, newValue, this.resultType, this.argumentNames, this.namespace);
    }

    public final ImmutableProcedureSpec withResultType(Class<?> value) {
        if (this.resultType == value) {
            return this;
        }
        Class<?> newValue = Objects.requireNonNull(value, "resultType");
        return new ImmutableProcedureSpec(this, this.name, newValue, this.argumentNames, this.namespace);
    }

    public final ImmutableProcedureSpec withArgumentNames(String ... elements) {
        List<String> newValue = ImmutableProcedureSpec.createUnmodifiableList(false, ImmutableProcedureSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableProcedureSpec(this, this.name, this.resultType, newValue, this.namespace);
    }

    public final ImmutableProcedureSpec withArgumentNames(Iterable<String> elements) {
        if (this.argumentNames == elements) {
            return this;
        }
        List<String> newValue = ImmutableProcedureSpec.createUnmodifiableList(false, ImmutableProcedureSpec.createSafeList(elements, true, false));
        return new ImmutableProcedureSpec(this, this.name, this.resultType, newValue, this.namespace);
    }

    public final ImmutableProcedureSpec withNamespace(CustomProcedure.Namespace value) {
        CustomProcedure.Namespace newValue = Objects.requireNonNull(value, "namespace");
        if (this.namespace == newValue) {
            return this;
        }
        return new ImmutableProcedureSpec(this, this.name, this.resultType, this.argumentNames, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcedureSpec && this.equalTo(0, (ImmutableProcedureSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcedureSpec another) {
        return this.name.equals(another.name) && this.resultType.equals(another.resultType) && this.argumentNames.equals(another.argumentNames) && this.namespace.equals((Object)another.namespace);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.resultType.hashCode();
        h += (h << 5) + this.argumentNames.hashCode();
        h += (h << 5) + this.namespace.hashCode();
        return h;
    }

    public String toString() {
        return "ProcedureSpec{name=" + this.name + ", resultType=" + this.resultType + ", argumentNames=" + this.argumentNames + ", namespace=" + this.namespace + "}";
    }

    public static ProcedureLookup.ProcedureSpec of(String name, Class<?> resultType, List<String> argumentNames, CustomProcedure.Namespace namespace) {
        return ImmutableProcedureSpec.of(name, resultType, argumentNames, namespace);
    }

    public static ProcedureLookup.ProcedureSpec of(String name, Class<?> resultType, Iterable<String> argumentNames, CustomProcedure.Namespace namespace) {
        return new ImmutableProcedureSpec(name, resultType, argumentNames, namespace);
    }

    static ProcedureLookup.ProcedureSpec copyOf(ProcedureLookup.ProcedureSpec instance) {
        if (instance instanceof ImmutableProcedureSpec) {
            return (ImmutableProcedureSpec)instance;
        }
        return ImmutableProcedureSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ProcedureLookup.ProcedureSpec", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_RESULT_TYPE = 2L;
        private static final long INIT_BIT_NAMESPACE = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private Class<?> resultType;
        private List<String> argumentNames = null;
        @Nullable
        private CustomProcedure.Namespace namespace;

        private Builder() {
        }

        public final Builder from(ImmutableProcedureSpec instance) {
            return this.from((ProcedureLookup.ProcedureSpec)instance);
        }

        final Builder from(ProcedureLookup.ProcedureSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.resultType(instance.resultType());
            this.addAllArgumentNames(instance.argumentNames());
            this.namespace(instance.namespace());
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder resultType(Class<?> resultType) {
            this.resultType = Objects.requireNonNull(resultType, "resultType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addArgumentName(String element) {
            if (this.argumentNames == null) {
                this.argumentNames = new ArrayList<String>();
            }
            this.argumentNames.add(Objects.requireNonNull(element, "argumentNames element"));
            return this;
        }

        public final Builder addArgumentNames(String ... elements) {
            if (this.argumentNames == null) {
                this.argumentNames = new ArrayList<String>();
            }
            for (String element : elements) {
                this.argumentNames.add(Objects.requireNonNull(element, "argumentNames element"));
            }
            return this;
        }

        public final Builder argumentNames(Iterable<String> elements) {
            this.argumentNames = new ArrayList<String>();
            return this.addAllArgumentNames(elements);
        }

        public final Builder addAllArgumentNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "argumentNames element");
            if (this.argumentNames == null) {
                this.argumentNames = new ArrayList<String>();
            }
            for (String element : elements) {
                this.argumentNames.add(Objects.requireNonNull(element, "argumentNames element"));
            }
            return this;
        }

        public final Builder namespace(CustomProcedure.Namespace namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.name = null;
            this.resultType = null;
            if (this.argumentNames != null) {
                this.argumentNames.clear();
            }
            this.namespace = null;
            return this;
        }

        public ProcedureLookup.ProcedureSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProcedureSpec(null, this.name, this.resultType, this.argumentNames == null ? Collections.emptyList() : ImmutableProcedureSpec.createUnmodifiableList(true, this.argumentNames), this.namespace);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("resultType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("namespace");
            }
            return "Cannot build ProcedureSpec, some of required attributes are not set " + attributes;
        }
    }
}

