/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc.syntax;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.annotation.CustomProcedure;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.doc.syntax.ImmutableProcedureSpec;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

final class ProcedureLookup {
    private final Map<String, ProcedureSpec> procedureSpecs;

    public static ProcedureLookup forPackages(List<String> packages) {
        Map<String, ProcedureSpec> procedureSpecs = packages.stream().map(pkg -> new Reflections(pkg, new Scanner[]{Scanners.MethodsAnnotated})).flatMap(r -> Stream.concat(r.getMethodsAnnotatedWith(Procedure.class).stream().map(ProcedureLookup::specFromProcedure), r.getMethodsAnnotatedWith(CustomProcedure.class).stream().map(ProcedureLookup::specFromCustomProcedure))).collect(Collectors.toMap(ProcedureSpec::name, s -> s, (keep, first) -> keep));
        return new ProcedureLookup(procedureSpecs);
    }

    private ProcedureLookup(Map<String, ProcedureSpec> procedureSpecs) {
        this.procedureSpecs = procedureSpecs;
    }

    Class<?> findResultType(String fullyQualifiedProcedureName) {
        ProcedureSpec spec = this.tryFindProcedureSpec(fullyQualifiedProcedureName).orElseThrow(() -> this.unknownProcedure(fullyQualifiedProcedureName));
        return spec.resultType();
    }

    List<String> findArgumentNames(String fullyQualifiedProcedureName) {
        ProcedureSpec spec = this.tryFindProcedureSpec(fullyQualifiedProcedureName).orElseThrow(() -> this.unknownProcedure(fullyQualifiedProcedureName));
        return spec.argumentNames();
    }

    private static ProcedureSpec specFromProcedure(Method method) {
        String name = method.getAnnotation(Procedure.class).name();
        if (name.isEmpty()) {
            name = method.getAnnotation(Procedure.class).value();
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Procedure %s.%s is missing a name.", (Object[])new Object[]{method.getDeclaringClass().getName(), method.getName()}));
        }
        Type resultType = method.getGenericReturnType();
        if (resultType != Void.TYPE) {
            if (!(resultType instanceof ParameterizedType)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Procedure %s.%s should return a Stream<T> where T is the actual result type.", (Object[])new Object[]{method.getDeclaringClass().getName(), method.getName()}));
            }
            Type actualResultType = ((ParameterizedType)resultType).getActualTypeArguments()[0];
            if (!(actualResultType instanceof Class)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Can't find result class for %s", (Object[])new Object[]{name}));
            }
            resultType = (Class)actualResultType;
        }
        return ImmutableProcedureSpec.of(name, (Class)resultType, ProcedureLookup.parameterNames(method));
    }

    private static ProcedureSpec specFromCustomProcedure(Method method) {
        String name = method.getAnnotation(CustomProcedure.class).value();
        Class<?> resultType = method.getReturnType();
        return ImmutableProcedureSpec.of(name, resultType, ProcedureLookup.parameterNames(method));
    }

    private static List<String> parameterNames(Method method) {
        return Arrays.stream(method.getParameters()).map(parameter -> parameter.isAnnotationPresent(Name.class) ? parameter.getAnnotation(Name.class).value() : parameter.getName()).collect(Collectors.toList());
    }

    private Optional<ProcedureSpec> tryFindProcedureSpec(String fullyQualifiedProcedureName) {
        return Optional.ofNullable(this.procedureSpecs.get(fullyQualifiedProcedureName));
    }

    private IllegalArgumentException unknownProcedure(String fullyQualifiedProcedureName) {
        return new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unknown procedure: `%s`", (Object[])new Object[]{fullyQualifiedProcedureName}));
    }

    @ValueClass
    static interface ProcedureSpec {
        public String name();

        public Class<?> resultType();

        public List<String> argumentNames();
    }
}

