/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.PreprocessorReader;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.doc.DocumentationTestToolsConstants;

public final class PartialsIncludeProcessor
extends IncludeProcessor {
    public boolean handles(String target) {
        return target.contains("partial$");
    }

    public void process(Document document, PreprocessorReader reader, String target, Map<String, Object> attributes) {
        Path partial = this.resolvePartial(target);
        String partialText = this.readPartial(partial);
        reader.push_include(partialText, target, null, Integer.MIN_VALUE, Collections.emptyMap());
    }

    @NotNull
    private Path resolvePartial(String target) {
        String relativePathToPartialFile = target.replace("partial$", "partials");
        return DocumentationTestToolsConstants.ASCIIDOC_PATH.resolve(relativePathToPartialFile);
    }

    private String readPartial(Path partial) {
        try {
            return Files.readString(partial);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading '" + partial + "'", e);
        }
    }
}

