/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc.syntax;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.extension.Postprocessor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.SoftAssertions;
import org.neo4j.gds.annotation.CustomProcedure;
import org.neo4j.gds.doc.syntax.ProcedureArgumentsExtractor;
import org.neo4j.gds.doc.syntax.ProcedureLookup;
import org.neo4j.gds.doc.syntax.ProcedureNameExtractor;
import org.neo4j.gds.doc.syntax.SyntaxMode;
import org.neo4j.gds.doc.syntax.SyntaxModeMeta;

class ProcedureSyntaxAutoChecker
extends Postprocessor {
    private static final String YIELD_FIELD_SEPARATOR = ",";
    private static final String YIELD_NAME_DATA_TYPE_SEPARATOR = ":";
    private static final String STYLE_SELECTOR = "style";
    private static final String STYLE_SELECTOR_VALUE = "source";
    private static final String LANGUAGE_SELECTOR = "language";
    private static final String LANGUAGE_SELECTOR_VALUE = "cypher";
    private static final String CONTEXT_SELECTOR = "context";
    private static final String TABLE_CONTEXT_VALUE = ":table";
    private static final String RESULTS_TABLE_TITLE = "Results";
    private static final String PARAMETERS_TABLE_TITLE = "Parameters";
    private static final String YIELD_KEYWORD = "YIELD";
    private static final String ROLE_SELECTOR = "role";
    private final Iterable<SyntaxModeMeta> syntaxModesPerPage;
    private final SoftAssertions syntaxAssertions;
    private final ProcedureLookup procedureLookup;

    public ProcedureSyntaxAutoChecker(Iterable<SyntaxModeMeta> syntaxModesPerPage, SoftAssertions syntaxAssertions, ProcedureLookup procedureLookup) {
        this.syntaxModesPerPage = syntaxModesPerPage;
        this.syntaxAssertions = syntaxAssertions;
        this.procedureLookup = procedureLookup;
    }

    public String process(Document document, String output) {
        this.syntaxModesPerPage.forEach(mode -> {
            List allSyntaxSectionsForMode = document.findBy(Map.of(ROLE_SELECTOR, mode.syntaxMode().mode()));
            ((ListAssert)Assertions.assertThat((List)allSyntaxSectionsForMode).as("There was an issue with `%s`", new Object[]{mode.syntaxMode().mode()})).hasSize(mode.sectionsOnPage());
            StructuralNode currentSyntaxSection = (StructuralNode)allSyntaxSectionsForMode.get(0);
            String codeSnippet = this.extractSyntaxCodeSnippet(currentSyntaxSection, mode.syntaxMode());
            String procedureName = ProcedureNameExtractor.findProcedureName(codeSnippet);
            List<String> documentedArguments = ProcedureArgumentsExtractor.findArguments(codeSnippet);
            List<String> expectedArguments = this.procedureLookup.findArgumentNames(procedureName);
            if (mode.syntaxMode().hasParameters) {
                ((ListAssert)this.syntaxAssertions.assertThat(documentedArguments).as("Asserting procedure arguments for `%s`", new Object[]{mode.syntaxMode().mode()})).containsExactlyInAnyOrderElementsOf(expectedArguments);
                this.assertTableValues(currentSyntaxSection, mode.syntaxMode(), PARAMETERS_TABLE_TITLE, expectedArguments);
            }
            Class<?> resultClass = this.procedureLookup.findResultType(procedureName);
            Collection<String> expectedResultFieldsFromCode = ProcedureSyntaxAutoChecker.extractExpectedResultFields(resultClass);
            Iterable<String> yieldResultColumns = this.extractDocResultFields(codeSnippet);
            ((IterableAssert)this.syntaxAssertions.assertThat(yieldResultColumns).as("Asserting YIELD result columns for `%s`", new Object[]{mode.syntaxMode().mode()})).containsExactlyInAnyOrderElementsOf(expectedResultFieldsFromCode);
            this.assertTableValues(currentSyntaxSection, mode.syntaxMode(), RESULTS_TABLE_TITLE, expectedResultFieldsFromCode);
        });
        return output;
    }

    private String extractSyntaxCodeSnippet(StructuralNode currentWorkingDocument, SyntaxMode mode) {
        List syntaxSectionContentStream = currentWorkingDocument.findBy(Map.of(STYLE_SELECTOR, STYLE_SELECTOR_VALUE, LANGUAGE_SELECTOR, LANGUAGE_SELECTOR_VALUE)).stream().map(StructuralNode::getContent).map(Object::toString).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(syntaxSectionContentStream).as("There is an issue finding the code block for `%s`", new Object[]{mode.mode()})).hasSize(1);
        return (String)syntaxSectionContentStream.get(0);
    }

    private void assertTableValues(StructuralNode currentWorkingDocument, SyntaxMode mode, String tableTitle, Iterable<String> expectedValues) {
        Stream<StructuralNode> resultTablesStream = currentWorkingDocument.findBy(Map.of(CONTEXT_SELECTOR, TABLE_CONTEXT_VALUE)).stream().filter(node -> node.getTitle().equals(tableTitle));
        ((ListAssert)((ListAssert)Assertions.assertThat(resultTablesStream).as("There is an issue finding the `%s` table for `%s`", new Object[]{tableTitle, mode.mode()})).hasSize(1)).allSatisfy(this.assertTableValues(mode, expectedValues, tableTitle));
    }

    private Consumer<StructuralNode> assertTableValues(SyntaxMode mode, Iterable<String> expectedValues, String tableTitle) {
        return rawDocTable -> {
            Assertions.assertThat((Object)rawDocTable).isInstanceOf(Table.class);
            Table docTable = (Table)rawDocTable;
            List documentedValues = docTable.getBody().stream().map(row -> (Cell)row.getCells().get(0)).map(Cell::getText).map(name -> name.split("\\s+")[0]).collect(Collectors.toList());
            ((ListAssert)this.syntaxAssertions.assertThat(documentedValues).as("Asserting `%s` table for `%s`", new Object[]{tableTitle, mode.mode()})).containsExactlyInAnyOrderElementsOf(expectedValues);
        };
    }

    private Iterable<String> extractDocResultFields(String syntaxCode) {
        String yield = syntaxCode.substring(syntaxCode.indexOf(YIELD_KEYWORD) + YIELD_KEYWORD.length()).trim();
        return Arrays.stream(yield.split(YIELD_FIELD_SEPARATOR)).map(yieldField -> yieldField.split(YIELD_NAME_DATA_TYPE_SEPARATOR)[0].trim()).collect(Collectors.toList());
    }

    private static Collection<String> extractExpectedResultFields(Class<?> resultClass) {
        return ProcedureSyntaxAutoChecker.findResultFields(resultClass).map(Member::getName).collect(Collectors.toList());
    }

    private static Stream<? extends Member> findResultFields(Class<?> resultClass) {
        return resultClass.isInterface() ? ProcedureSyntaxAutoChecker.resultFieldsFromInterfaceMethods(resultClass) : ProcedureSyntaxAutoChecker.resultFieldsFromClassFields(resultClass);
    }

    private static Stream<Method> resultFieldsFromInterfaceMethods(Class<?> resultClass) {
        return Arrays.stream(resultClass.getDeclaredMethods()).filter(ProcedureSyntaxAutoChecker::includeMethodInResult);
    }

    private static Stream<Field> resultFieldsFromClassFields(Class<?> resultClass) {
        return Arrays.stream(resultClass.getFields()).filter(ProcedureSyntaxAutoChecker::includeFieldInResult);
    }

    private static boolean includeMethodInResult(AnnotatedElement method) {
        return method.isAnnotationPresent(CustomProcedure.ResultField.class);
    }

    private static boolean includeFieldInResult(Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }
}

