/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.Treeprocessor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.io.TempDir;
import org.neo4j.gds.BaseProcTest;
import org.neo4j.gds.compat.CompatUserAggregationFunction;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.doc.DocumentationTestToolsConstants;
import org.neo4j.gds.doc.PartialsIncludeProcessor;
import org.neo4j.gds.doc.QueryCollectingTreeProcessor;
import org.neo4j.gds.doc.QueryExample;
import org.neo4j.gds.doc.QueryExampleGroup;
import org.neo4j.gds.doc.syntax.DocQuery;
import org.neo4j.graphdb.Result;

public abstract class MultiFileDocTestBase
extends BaseProcTest {
    private List<DocQuery> beforeEachQueries;
    private List<DocQuery> beforeAllQueries;
    private List<QueryExampleGroup> queryExampleGroups;

    protected abstract List<String> adocPaths();

    @BeforeEach
    void setUp(@TempDir File workingDirectory) throws Exception {
        Class[] clazzArray = new Class[]{};
        this.registerProcedures(this.procedures().toArray(clazzArray));
        this.registerFunctions(this.functions().toArray(clazzArray));
        for (CompatUserAggregationFunction function : this.aggregationFunctions()) {
            this.registerAggregationFunction(function);
        }
        QueryCollectingTreeProcessor treeProcessor = new QueryCollectingTreeProcessor();
        PartialsIncludeProcessor includeProcessor = new PartialsIncludeProcessor();
        try (Asciidoctor asciidoctor = Asciidoctor.Factory.create();){
            asciidoctor.javaExtensionRegistry().includeProcessor((IncludeProcessor)includeProcessor).treeprocessor((Treeprocessor)treeProcessor);
            OptionsBuilder options = Options.builder().toDir(workingDirectory).safe(SafeMode.UNSAFE);
            for (File docFile : this.adocFiles()) {
                asciidoctor.convertFile(docFile, options.build());
            }
        }
        this.beforeEachQueries = treeProcessor.getBeforeEachQueries();
        this.queryExampleGroups = treeProcessor.getQueryExampleGroups();
        this.beforeAllQueries = treeProcessor.getBeforeAllQueries();
        if (!this.setupNeo4jGraphPerTest()) {
            this.beforeAllQueries.forEach(this::runDocQuery);
        }
    }

    private List<File> adocFiles() {
        return this.adocPaths().stream().map(DocumentationTestToolsConstants.ASCIIDOC_PATH::resolve).map(Path::toFile).collect(Collectors.toList());
    }

    @TestFactory
    Collection<DynamicTest> runTests() {
        ((ListAssert)Assertions.assertThat(this.queryExampleGroups).as("Query Example Groups should not be empty!", new Object[0])).isNotEmpty();
        return this.queryExampleGroups.stream().map(this::createDynamicTest).collect(Collectors.toList());
    }

    boolean setupNeo4jGraphPerTest() {
        return false;
    }

    private void beforeEachTest() {
        if (this.setupNeo4jGraphPerTest()) {
            this.beforeAllQueries.forEach(this::runDocQuery);
        }
        this.beforeEachQueries.forEach(this::runDocQuery);
    }

    private void runDocQuery(DocQuery docQuery) {
        if (docQuery.runAsOperator()) {
            String operatorHandle = docQuery.operator();
            super.runQuery(operatorHandle, docQuery.query());
        } else {
            super.runQuery(docQuery.query());
        }
    }

    private DynamicTest createDynamicTest(QueryExampleGroup queryExampleGroup) {
        return DynamicTest.dynamicTest((String)queryExampleGroup.displayName(), () -> {
            try {
                this.beforeEachTest();
                queryExampleGroup.queryExamples().forEach(this::runQueryExample);
            }
            finally {
                this.cleanup().run();
            }
        });
    }

    private void runQueryExampleWithResultConsumer(QueryExample queryExample, Consumer<Result> check) {
        if (!queryExample.runAsOperator()) {
            super.runQueryWithResultConsumer(queryExample.query(), check);
        } else {
            String operatorHandle = queryExample.operator();
            super.runQueryWithResultConsumer(operatorHandle, queryExample.query(), check);
        }
    }

    private void runQueryExampleAndAssertResults(QueryExample queryExample) {
        this.runQueryExampleWithResultConsumer(queryExample, result -> {
            Assertions.assertThat(queryExample.resultColumns()).containsExactlyElementsOf((Iterable)result.columns());
            ArrayList actualResults = new ArrayList();
            while (result.hasNext()) {
                Map actualResultRow = result.next();
                List actualResultValues = queryExample.resultColumns().stream().map(column -> this.valueToString(actualResultRow.get(column))).collect(Collectors.toList());
                actualResults.add(actualResultValues);
            }
            List<List<String>> expectedResults = this.reducePrecisionOfDoubles(queryExample.results());
            ((ListAssert)Assertions.assertThat(actualResults).as(queryExample.query(), new Object[0])).containsExactlyElementsOf(expectedResults);
        });
    }

    private void runQueryExample(QueryExample queryExample) {
        if (queryExample.assertResults()) {
            this.runQueryExampleAndAssertResults(queryExample);
        } else {
            AssertionsForClassTypes.assertThatNoException().isThrownBy(() -> this.runDocQuery(queryExample));
        }
    }

    protected abstract List<Class<?>> procedures();

    protected List<Class<?>> functions() {
        return List.of();
    }

    protected List<CompatUserAggregationFunction> aggregationFunctions() {
        return List.of();
    }

    Runnable cleanup() {
        return GraphStoreCatalog::removeAllLoadedGraphs;
    }

    private List<List<String>> reducePrecisionOfDoubles(Collection<List<String>> resultsFromDoc) {
        return resultsFromDoc.stream().map(list -> list.stream().map(string -> {
            try {
                return DocumentationTestToolsConstants.FLOAT_FORMAT.format(Double.parseDouble(string));
            }
            catch (NumberFormatException e) {
                return string;
            }
        }).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private String valueToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof Double) {
            return DocumentationTestToolsConstants.FLOAT_FORMAT.format(value);
        }
        return value.toString();
    }
}

