/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc.syntax;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.annotation.ReturnType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.doc.syntax.ImmutableAggregationMethods;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

final class ProcedureLookup {
    private final List<Method> procedureMethods;
    private final List<AggregationMethods> aggregationMethods;

    public static ProcedureLookup forPackages(List<String> packages) {
        List reflections = packages.stream().map(pkg -> new Reflections(pkg, new Scanner[]{Scanners.MethodsAnnotated})).collect(Collectors.toList());
        List<Method> methods = reflections.stream().flatMap(r -> r.getMethodsAnnotatedWith(Procedure.class).stream()).collect(Collectors.toList());
        List<AggregationMethods> aggregationMethods = reflections.stream().flatMap(r -> r.getMethodsAnnotatedWith(UserAggregationFunction.class).stream().map(procedure -> {
            Class<?> aggregatorType = procedure.getReturnType();
            Method update = Arrays.stream(aggregatorType.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(UserAggregationUpdate.class)).findFirst().orElseThrow(() -> new IllegalArgumentException("UserAggregationFunction without a UserAggregationUpdate"));
            Method result = Arrays.stream(aggregatorType.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(UserAggregationResult.class)).findFirst().orElseThrow(() -> new IllegalArgumentException("UserAggregationFunction without a UserAggregationResult"));
            return ImmutableAggregationMethods.of(procedure, update, result);
        })).collect(Collectors.toList());
        return new ProcedureLookup(methods, aggregationMethods);
    }

    private ProcedureLookup(List<Method> procedureMethods, List<AggregationMethods> aggregationMethods) {
        this.procedureMethods = procedureMethods;
        this.aggregationMethods = aggregationMethods;
    }

    Class<?> findResultType(String fullyQualifiedProcedureName) {
        Method method = this.tryFindProcedureMethod(fullyQualifiedProcedureName).or(() -> this.tryFindAggregationResultMethod(fullyQualifiedProcedureName)).orElseThrow(() -> this.unknownProcedure(fullyQualifiedProcedureName));
        ReturnType returnType = method.getAnnotation(ReturnType.class);
        if (returnType != null) {
            return returnType.value();
        }
        ParameterizedType resultType = (ParameterizedType)method.getGenericReturnType();
        Type actualTypeArgument = resultType.getActualTypeArguments()[0];
        if (actualTypeArgument instanceof Class) {
            return (Class)actualTypeArgument;
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Can't find result class for %s", (Object[])new Object[]{fullyQualifiedProcedureName}));
    }

    List<String> findArgumentNames(String fullyQualifiedProcedureName) {
        Method method = this.tryFindProcedureMethod(fullyQualifiedProcedureName).or(() -> this.tryFindAggregationUpdateMethod(fullyQualifiedProcedureName)).orElseThrow(() -> this.unknownProcedure(fullyQualifiedProcedureName));
        Parameter[] parameters = method.getParameters();
        ArrayList<String> result = new ArrayList<String>(parameters.length);
        for (Parameter parameter : parameters) {
            if (parameter.isAnnotationPresent(Name.class)) {
                result.add(parameter.getAnnotation(Name.class).value());
                continue;
            }
            result.add(parameter.getName());
        }
        return result;
    }

    private Optional<Method> tryFindProcedureMethod(String fullyQualifiedProcedureName) {
        return this.procedureMethods.stream().filter(method -> {
            Procedure annotation = method.getAnnotation(Procedure.class);
            return annotation.name().equals(fullyQualifiedProcedureName) || annotation.value().equals(fullyQualifiedProcedureName);
        }).findFirst();
    }

    private Optional<Method> tryFindAggregationUpdateMethod(String fullyQualifiedProcedureName) {
        return this.findAggregations(fullyQualifiedProcedureName).map(AggregationMethods::update).findFirst();
    }

    private Optional<Method> tryFindAggregationResultMethod(String fullyQualifiedProcedureName) {
        return this.findAggregations(fullyQualifiedProcedureName).map(AggregationMethods::result).findFirst();
    }

    private Stream<AggregationMethods> findAggregations(String fullyQualifiedProcedureName) {
        return this.aggregationMethods.stream().filter(aggregation -> {
            UserAggregationFunction annotation = aggregation.procedure().getAnnotation(UserAggregationFunction.class);
            return annotation.name().equals(fullyQualifiedProcedureName) || annotation.value().equals(fullyQualifiedProcedureName);
        });
    }

    private IllegalArgumentException unknownProcedure(String fullyQualifiedProcedureName) {
        return new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unknown procedure: `%s`", (Object[])new Object[]{fullyQualifiedProcedureName}));
    }

    @ValueClass
    static interface AggregationMethods {
        public Method procedure();

        public Method update();

        public Method result();
    }
}

