/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc.syntax;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.doc.syntax.DocQuery;

@ParametersAreNonnullByDefault
@Generated(from="DocQuery", generator="Immutables")
@Immutable
public final class ImmutableDocQuery
implements DocQuery {
    private final String query;
    private final transient boolean runAsOperator;
    private final String operator;
    private final boolean skipTest;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDocQuery(String query, String operator, boolean skipTest) {
        this.query = Objects.requireNonNull(query, "query");
        this.initShim.operator(Objects.requireNonNull(operator, "operator"));
        this.initShim.skipTest(skipTest);
        this.runAsOperator = this.initShim.runAsOperator();
        this.operator = this.initShim.operator();
        this.skipTest = this.initShim.skipTest();
        this.initShim = null;
    }

    private ImmutableDocQuery(Builder builder) {
        this.query = builder.query;
        if (builder.operator != null) {
            this.initShim.operator(builder.operator);
        }
        if (builder.skipTestIsSet()) {
            this.initShim.skipTest(builder.skipTest);
        }
        this.runAsOperator = this.initShim.runAsOperator();
        this.operator = this.initShim.operator();
        this.skipTest = this.initShim.skipTest();
        this.initShim = null;
    }

    private ImmutableDocQuery(ImmutableDocQuery original, String query, String operator, boolean skipTest) {
        this.query = query;
        this.initShim.operator(operator);
        this.initShim.skipTest(skipTest);
        this.runAsOperator = this.initShim.runAsOperator();
        this.operator = this.initShim.operator();
        this.skipTest = this.initShim.skipTest();
        this.initShim = null;
    }

    private boolean runAsOperatorInitialize() {
        return DocQuery.super.runAsOperator();
    }

    private String operatorInitialize() {
        return DocQuery.super.operator();
    }

    private boolean skipTestInitialize() {
        return DocQuery.super.skipTest();
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public boolean runAsOperator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.runAsOperator() : this.runAsOperator;
    }

    @Override
    public String operator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.operator() : this.operator;
    }

    @Override
    public boolean skipTest() {
        InitShim shim = this.initShim;
        return shim != null ? shim.skipTest() : this.skipTest;
    }

    public final ImmutableDocQuery withQuery(String value) {
        String newValue = Objects.requireNonNull(value, "query");
        if (this.query.equals(newValue)) {
            return this;
        }
        return new ImmutableDocQuery(this, newValue, this.operator, this.skipTest);
    }

    public final ImmutableDocQuery withOperator(String value) {
        String newValue = Objects.requireNonNull(value, "operator");
        if (this.operator.equals(newValue)) {
            return this;
        }
        return new ImmutableDocQuery(this, this.query, newValue, this.skipTest);
    }

    public final ImmutableDocQuery withSkipTest(boolean value) {
        if (this.skipTest == value) {
            return this;
        }
        return new ImmutableDocQuery(this, this.query, this.operator, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDocQuery && this.equalTo((ImmutableDocQuery)another);
    }

    private boolean equalTo(ImmutableDocQuery another) {
        return this.query.equals(another.query) && this.runAsOperator == another.runAsOperator && this.operator.equals(another.operator) && this.skipTest == another.skipTest;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.query.hashCode();
        h += (h << 5) + Boolean.hashCode(this.runAsOperator);
        h += (h << 5) + this.operator.hashCode();
        h += (h << 5) + Boolean.hashCode(this.skipTest);
        return h;
    }

    public String toString() {
        return "DocQuery{query=" + this.query + ", runAsOperator=" + this.runAsOperator + ", operator=" + this.operator + ", skipTest=" + this.skipTest + "}";
    }

    public static DocQuery of(String query, String operator, boolean skipTest) {
        return new ImmutableDocQuery(query, operator, skipTest);
    }

    public static DocQuery copyOf(DocQuery instance) {
        if (instance instanceof ImmutableDocQuery) {
            return (ImmutableDocQuery)instance;
        }
        return ImmutableDocQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DocQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_QUERY = 1L;
        private static final long OPT_BIT_SKIP_TEST = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String query;
        @Nullable
        private String operator;
        private boolean skipTest;

        private Builder() {
        }

        public final Builder from(DocQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.query(instance.query());
            this.operator(instance.operator());
            this.skipTest(instance.skipTest());
            return this;
        }

        public final Builder query(String query) {
            this.query = Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder operator(String operator) {
            this.operator = Objects.requireNonNull(operator, "operator");
            return this;
        }

        public final Builder skipTest(boolean skipTest) {
            this.skipTest = skipTest;
            this.optBits |= 1L;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.query = null;
            this.operator = null;
            this.skipTest = false;
            return this;
        }

        public DocQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDocQuery(this);
        }

        private boolean skipTestIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("query");
            }
            return "Cannot build DocQuery, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="DocQuery", generator="Immutables")
    private final class InitShim {
        private byte runAsOperatorBuildStage = 0;
        private boolean runAsOperator;
        private byte operatorBuildStage = 0;
        private String operator;
        private byte skipTestBuildStage = 0;
        private boolean skipTest;

        private InitShim() {
        }

        boolean runAsOperator() {
            if (this.runAsOperatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.runAsOperatorBuildStage == 0) {
                this.runAsOperatorBuildStage = (byte)-1;
                this.runAsOperator = ImmutableDocQuery.this.runAsOperatorInitialize();
                this.runAsOperatorBuildStage = 1;
            }
            return this.runAsOperator;
        }

        String operator() {
            if (this.operatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.operatorBuildStage == 0) {
                this.operatorBuildStage = (byte)-1;
                this.operator = Objects.requireNonNull(ImmutableDocQuery.this.operatorInitialize(), "operator");
                this.operatorBuildStage = 1;
            }
            return this.operator;
        }

        void operator(String operator) {
            this.operator = operator;
            this.operatorBuildStage = 1;
        }

        boolean skipTest() {
            if (this.skipTestBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.skipTestBuildStage == 0) {
                this.skipTestBuildStage = (byte)-1;
                this.skipTest = ImmutableDocQuery.this.skipTestInitialize();
                this.skipTestBuildStage = 1;
            }
            return this.skipTest;
        }

        void skipTest(boolean skipTest) {
            this.skipTest = skipTest;
            this.skipTestBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.runAsOperatorBuildStage == -1) {
                attributes.add("runAsOperator");
            }
            if (this.operatorBuildStage == -1) {
                attributes.add("operator");
            }
            if (this.skipTestBuildStage == -1) {
                attributes.add("skipTest");
            }
            return "Cannot build DocQuery, attribute initializers form cycle " + attributes;
        }
    }
}

