/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc.syntax;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.doc.syntax.ProcedureLookup;

@ParametersAreNonnullByDefault
@Generated(from="ProcedureLookup.AggregationMethods", generator="Immutables")
@Immutable
public final class ImmutableAggregationMethods
implements ProcedureLookup.AggregationMethods {
    private final Method procedure;
    private final Method update;
    private final Method result;

    private ImmutableAggregationMethods(Method procedure, Method update, Method result) {
        this.procedure = Objects.requireNonNull(procedure, "procedure");
        this.update = Objects.requireNonNull(update, "update");
        this.result = Objects.requireNonNull(result, "result");
    }

    private ImmutableAggregationMethods(ImmutableAggregationMethods original, Method procedure, Method update, Method result) {
        this.procedure = procedure;
        this.update = update;
        this.result = result;
    }

    @Override
    public Method procedure() {
        return this.procedure;
    }

    @Override
    public Method update() {
        return this.update;
    }

    @Override
    public Method result() {
        return this.result;
    }

    public final ImmutableAggregationMethods withProcedure(Method value) {
        if (this.procedure == value) {
            return this;
        }
        Method newValue = Objects.requireNonNull(value, "procedure");
        return new ImmutableAggregationMethods(this, newValue, this.update, this.result);
    }

    public final ImmutableAggregationMethods withUpdate(Method value) {
        if (this.update == value) {
            return this;
        }
        Method newValue = Objects.requireNonNull(value, "update");
        return new ImmutableAggregationMethods(this, this.procedure, newValue, this.result);
    }

    public final ImmutableAggregationMethods withResult(Method value) {
        if (this.result == value) {
            return this;
        }
        Method newValue = Objects.requireNonNull(value, "result");
        return new ImmutableAggregationMethods(this, this.procedure, this.update, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAggregationMethods && this.equalTo((ImmutableAggregationMethods)another);
    }

    private boolean equalTo(ImmutableAggregationMethods another) {
        return this.procedure.equals(another.procedure) && this.update.equals(another.update) && this.result.equals(another.result);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.procedure.hashCode();
        h += (h << 5) + this.update.hashCode();
        h += (h << 5) + this.result.hashCode();
        return h;
    }

    public String toString() {
        return "AggregationMethods{procedure=" + this.procedure + ", update=" + this.update + ", result=" + this.result + "}";
    }

    public static ProcedureLookup.AggregationMethods of(Method procedure, Method update, Method result) {
        return new ImmutableAggregationMethods(procedure, update, result);
    }

    static ProcedureLookup.AggregationMethods copyOf(ProcedureLookup.AggregationMethods instance) {
        if (instance instanceof ImmutableAggregationMethods) {
            return (ImmutableAggregationMethods)instance;
        }
        return ImmutableAggregationMethods.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProcedureLookup.AggregationMethods", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_PROCEDURE = 1L;
        private static final long INIT_BIT_UPDATE = 2L;
        private static final long INIT_BIT_RESULT = 4L;
        private long initBits = 7L;
        @Nullable
        private Method procedure;
        @Nullable
        private Method update;
        @Nullable
        private Method result;

        private Builder() {
        }

        public final Builder from(ImmutableAggregationMethods instance) {
            return this.from((ProcedureLookup.AggregationMethods)instance);
        }

        final Builder from(ProcedureLookup.AggregationMethods instance) {
            Objects.requireNonNull(instance, "instance");
            this.procedure(instance.procedure());
            this.update(instance.update());
            this.result(instance.result());
            return this;
        }

        public final Builder procedure(Method procedure) {
            this.procedure = Objects.requireNonNull(procedure, "procedure");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder update(Method update) {
            this.update = Objects.requireNonNull(update, "update");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder result(Method result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.procedure = null;
            this.update = null;
            this.result = null;
            return this;
        }

        public ProcedureLookup.AggregationMethods build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAggregationMethods(null, this.procedure, this.update, this.result);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("procedure");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("update");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build AggregationMethods, some of required attributes are not set " + attributes;
        }
    }
}

