/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.extension.Treeprocessor;
import org.neo4j.gds.doc.ImmutableQueryExample;
import org.neo4j.gds.doc.ImmutableQueryExampleGroup;
import org.neo4j.gds.doc.QueryExample;
import org.neo4j.gds.doc.QueryExampleGroup;
import org.neo4j.gds.doc.syntax.DocQuery;
import org.neo4j.gds.doc.syntax.ImmutableDocQuery;
import org.neo4j.gds.utils.StringFormatting;

public class QueryCollectingTreeProcessor
extends Treeprocessor {
    private static final String CODE_BLOCK_CONTEXT = ":listing";
    private static final String TABLE_CONTEXT = ":table";
    private static final String SETUP_QUERY_ROLE = "setup-query";
    private static final String GRAPH_PROJECT_QUERY_ROLE = "graph-project-query";
    private static final String QUERY_EXAMPLE_ROLE = "query-example";
    private static final String TEST_TYPE_NO_RESULT = "no-result";
    private static final String TEST_GROUP_ATTRIBUTE = "group";
    private static final String TEST_OPERATOR_ATTRIBUTE = "operator";
    private static final String ROLE_SELECTOR = "role";
    private static final String SKIP_TEST = "skip-test";
    private List<DocQuery> beforeAllQueries = new ArrayList<DocQuery>();
    private List<DocQuery> beforeEachQueries = new ArrayList<DocQuery>();
    private Map<String, List<QueryExample>> queryExampleMap = new HashMap<String, List<QueryExample>>();

    public List<DocQuery> beforeAllQueries() {
        return this.beforeAllQueries;
    }

    public List<DocQuery> beforeEachQueries() {
        return this.beforeEachQueries;
    }

    public List<QueryExampleGroup> queryExamples() {
        return this.queryExampleMap.entrySet().stream().map(entry -> ImmutableQueryExampleGroup.of((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    public Document process(Document document) {
        this.beforeAllQueries.addAll(this.collectBeforeAllQueries((StructuralNode)document));
        this.beforeEachQueries.addAll(this.collectBeforeEachQueries((StructuralNode)document));
        this.collectQueryExamples((StructuralNode)document);
        return document;
    }

    private List<DocQuery> collectBeforeAllQueries(StructuralNode document) {
        return this.collectSetupQueries(document, SETUP_QUERY_ROLE);
    }

    private List<DocQuery> collectBeforeEachQueries(StructuralNode document) {
        return this.collectSetupQueries(document, GRAPH_PROJECT_QUERY_ROLE);
    }

    private List<DocQuery> collectSetupQueries(StructuralNode node, String setupQueryType) {
        List nodes = node.findBy(Map.of(ROLE_SELECTOR, setupQueryType));
        return nodes.stream().map(QueryCollectingTreeProcessor::createSetupQuery).collect(Collectors.toList());
    }

    private static DocQuery createSetupQuery(StructuralNode structuralNode) {
        String content = structuralNode.getContent().toString();
        ImmutableDocQuery.Builder builder = DocQuery.builder();
        builder.query(QueryCollectingTreeProcessor.undoReplacements(content)).build();
        if (structuralNode.hasAttribute((Object)TEST_OPERATOR_ATTRIBUTE)) {
            builder.operator(structuralNode.getAttribute((Object)TEST_OPERATOR_ATTRIBUTE).toString());
        }
        builder.skipTest(QueryCollectingTreeProcessor.parseSkipTest(structuralNode));
        return builder.build();
    }

    private void collectQueryExamples(StructuralNode node) {
        List queryExampleNodesRaw = node.findBy(Map.of(ROLE_SELECTOR, QUERY_EXAMPLE_ROLE));
        Map<String, List<StructuralNode>> groupedQueryExampleNodes = this.collectQueryExampleNodes(queryExampleNodesRaw);
        groupedQueryExampleNodes.forEach((displayName, queryExampleNodes) -> {
            List queryExamples = queryExampleNodes.stream().map(this::convertToQueryExample).collect(Collectors.toList());
            this.queryExampleMap.merge((String)displayName, queryExamples, (oldValue, newValue) -> {
                oldValue.addAll(newValue);
                return oldValue;
            });
        });
    }

    private QueryExample convertToQueryExample(StructuralNode queryExampleNode) {
        StructuralNode codeBlock = this.findByContext(queryExampleNode, CODE_BLOCK_CONTEXT);
        String query = QueryCollectingTreeProcessor.undoReplacements(codeBlock.getContent().toString());
        ImmutableQueryExample.Builder queryExampleBuilder = QueryExample.builder().query(query);
        if (queryExampleNode.hasAttribute((Object)TEST_OPERATOR_ATTRIBUTE)) {
            queryExampleBuilder.operator(queryExampleNode.getAttribute((Object)TEST_OPERATOR_ATTRIBUTE).toString());
        }
        queryExampleBuilder.skipTest(QueryCollectingTreeProcessor.parseSkipTest(queryExampleNode));
        if (Boolean.parseBoolean(queryExampleNode.getAttribute((Object)TEST_TYPE_NO_RESULT, (Object)false).toString())) {
            queryExampleBuilder.assertResults(false);
        } else {
            Table resultsTable = (Table)this.findByContext(queryExampleNode, TABLE_CONTEXT);
            List<String> resultColumns = ((Row)resultsTable.getHeader().get(0)).getCells().stream().map(Cell::getText).collect(Collectors.toList());
            queryExampleBuilder.resultColumns(resultColumns);
            List body = resultsTable.getBody();
            for (Row resultRow : body) {
                queryExampleBuilder.addResult(resultRow.getCells().stream().map(Cell::getText).map(QueryCollectingTreeProcessor::undoReplacements).collect(Collectors.toList()));
            }
        }
        return queryExampleBuilder.build();
    }

    private Map<String, List<StructuralNode>> collectQueryExampleNodes(Iterable<StructuralNode> queryExampleNodes) {
        HashMap<String, List<StructuralNode>> groupedQueryExampleNodes = new HashMap<String, List<StructuralNode>>();
        queryExampleNodes.forEach(queryExampleNode -> {
            String testDisplayName = this.extractDisplayName((StructuralNode)queryExampleNode);
            groupedQueryExampleNodes.putIfAbsent(testDisplayName, new ArrayList());
            ((List)groupedQueryExampleNodes.get(testDisplayName)).add(queryExampleNode);
        });
        return groupedQueryExampleNodes;
    }

    private String extractDisplayName(StructuralNode queryExampleNode) {
        Object testGroupAttribute = queryExampleNode.getAttribute((Object)TEST_GROUP_ATTRIBUTE);
        if (testGroupAttribute != null) {
            return testGroupAttribute.toString();
        }
        StructuralNode codeBlock = this.findByContext(queryExampleNode, CODE_BLOCK_CONTEXT);
        String query = QueryCollectingTreeProcessor.undoReplacements(codeBlock.getContent().toString());
        return codeBlock.getTitle() == null ? query : codeBlock.getTitle();
    }

    private StructuralNode findByContext(StructuralNode node, String context) {
        return (StructuralNode)node.findBy(Map.of("context", context)).stream().findFirst().orElseThrow(() -> new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No nodes found for context '%s'", (Object[])new Object[]{context})));
    }

    private static String undoReplacements(String content) {
        return content.replace("&gt;", ">").replace("&lt;", "<");
    }

    private static boolean parseSkipTest(StructuralNode node) {
        return Boolean.parseBoolean(node.getAttribute((Object)SKIP_TEST, (Object)false).toString());
    }
}

