/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.PreprocessorReader;

public final class PartialsIncludeProcessor
extends IncludeProcessor {
    public boolean handles(String target) {
        return target.contains("partial$");
    }

    public void process(Document document, PreprocessorReader reader, String target, Map<String, Object> attributes) {
        String base_dir = document.getOptions().get("base_dir").toString();
        String relativePathToPartialFile = target.replace("partial$", "partials");
        File partialFile = Paths.get(base_dir, relativePathToPartialFile).toFile();
        try (BufferedReader partialFileReader = new BufferedReader(new FileReader(partialFile, StandardCharsets.UTF_8));){
            String partialFileContent = partialFileReader.lines().collect(Collectors.joining(System.lineSeparator()));
            reader.push_include(partialFileContent, target, new File(".").getAbsolutePath(), 1, attributes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

