/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.Treeprocessor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.io.TempDir;
import org.neo4j.gds.BaseProcTest;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.doc.PartialsIncludeProcessor;
import org.neo4j.gds.doc.QueryCollectingTreeProcessor;
import org.neo4j.gds.doc.QueryExample;
import org.neo4j.gds.doc.QueryExampleGroup;

public abstract class MultiFileDocTestBase
extends BaseProcTest {
    @TempDir
    File workDir;
    private static final Path ASCIIDOC_PATH = Paths.get("build/doc-sources/modules/ROOT", new String[0]);
    private List<String> beforeEachQueries;
    private List<String> beforeAllQueries;
    private List<QueryExampleGroup> queryExampleGroups;
    private static final NumberFormat FLOAT_FORMAT = DecimalFormat.getInstance(Locale.ENGLISH);

    protected abstract List<String> adocPaths();

    private List<File> adocFiles() {
        return this.adocPaths().stream().map(ASCIIDOC_PATH::resolve).map(Path::toFile).collect(Collectors.toList());
    }

    @BeforeEach
    void setUp() throws Exception {
        QueryCollectingTreeProcessor treeProcessor;
        Class[] clazzArray = new Class[]{};
        this.registerProcedures(this.procedures().toArray(clazzArray));
        this.registerFunctions(this.functions().toArray(clazzArray));
        this.registerAggregationFunctions(this.aggregationFunctions().toArray(clazzArray));
        try (Asciidoctor asciidoctor = Asciidoctor.Factory.create();){
            treeProcessor = new QueryCollectingTreeProcessor();
            asciidoctor.javaExtensionRegistry().includeProcessor((IncludeProcessor)new PartialsIncludeProcessor()).treeprocessor((Treeprocessor)treeProcessor);
            OptionsBuilder options = OptionsBuilder.options().baseDir(ASCIIDOC_PATH.toFile()).toDir(this.workDir).safe(SafeMode.UNSAFE);
            for (File docFile : this.adocFiles()) {
                Assertions.assertThat((File)docFile).exists().canRead();
                asciidoctor.convertFile(docFile, options);
            }
        }
        this.beforeEachQueries = treeProcessor.beforeEachQueries();
        this.queryExampleGroups = treeProcessor.queryExamples();
        this.beforeAllQueries = treeProcessor.beforeAllQueries();
        if (!this.setupNeo4jGraphPerTest()) {
            this.beforeAllQueries.forEach(arg_0 -> ((MultiFileDocTestBase)this).runQuery(arg_0));
        }
    }

    @TestFactory
    Collection<DynamicTest> runTests() {
        ((ListAssert)Assertions.assertThat(this.queryExampleGroups).as("Query Example Groups should not be empty!", new Object[0])).isNotEmpty();
        return this.queryExampleGroups.stream().map(this::createDynamicTest).collect(Collectors.toList());
    }

    boolean setupNeo4jGraphPerTest() {
        return false;
    }

    private void beforeEachTest() {
        if (this.setupNeo4jGraphPerTest()) {
            this.beforeAllQueries.forEach(arg_0 -> ((MultiFileDocTestBase)this).runQuery(arg_0));
        }
        this.beforeEachQueries.forEach(arg_0 -> ((MultiFileDocTestBase)this).runQuery(arg_0));
    }

    private DynamicTest createDynamicTest(QueryExampleGroup queryExampleGroup) {
        return DynamicTest.dynamicTest((String)queryExampleGroup.displayName(), () -> {
            try {
                this.beforeEachTest();
                queryExampleGroup.queryExamples().forEach(this::runQueryExample);
            }
            finally {
                this.cleanup().run();
            }
        });
    }

    protected abstract List<Class<?>> procedures();

    protected List<Class<?>> functions() {
        return List.of();
    }

    protected List<Class<?>> aggregationFunctions() {
        return List.of();
    }

    Runnable cleanup() {
        return GraphStoreCatalog::removeAllLoadedGraphs;
    }

    private void runQueryExample(QueryExample queryExample) {
        if (queryExample.assertResults()) {
            this.runQueryExampleAndAssertResults(queryExample);
        } else {
            Assertions.assertThatNoException().isThrownBy(() -> this.runQuery(queryExample.query()));
        }
    }

    private void runQueryExampleAndAssertResults(QueryExample queryExample) {
        this.runQueryWithResultConsumer(queryExample.query(), result -> {
            Assertions.assertThat(queryExample.resultColumns()).containsExactlyElementsOf((Iterable)result.columns());
            ArrayList actualResults = new ArrayList();
            while (result.hasNext()) {
                Map actualResultRow = result.next();
                List actualResultValues = queryExample.resultColumns().stream().map(column -> this.valueToString(actualResultRow.get(column))).collect(Collectors.toList());
                actualResults.add(actualResultValues);
            }
            List<List<String>> expectedResults = this.reducePrecisionOfDoubles(queryExample.results());
            ((ListAssert)Assertions.assertThat(actualResults).as(queryExample.query(), new Object[0])).containsExactlyElementsOf(expectedResults);
        });
    }

    private List<List<String>> reducePrecisionOfDoubles(Collection<List<String>> resultsFromDoc) {
        return resultsFromDoc.stream().map(list -> list.stream().map(string -> {
            try {
                return FLOAT_FORMAT.format(Double.parseDouble(string));
            }
            catch (NumberFormatException e) {
                return string;
            }
        }).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private String valueToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof Double) {
            return FLOAT_FORMAT.format(value);
        }
        return value.toString();
    }

    static {
        FLOAT_FORMAT.setMaximumFractionDigits(15);
        FLOAT_FORMAT.setGroupingUsed(false);
    }
}

