/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher.nodeproperties;

import org.neo4j.gds.api.properties.nodes.FloatArrayNodePropertyValues;
import org.neo4j.gds.collections.HugeSparseFloatArrayList;
import org.neo4j.gds.core.cypher.UpdatableNodeProperty;
import org.neo4j.gds.utils.Neo4jValueConversion;
import org.neo4j.values.storable.Value;

public class UpdatableFloatArrayNodeProperty
implements UpdatableNodeProperty,
FloatArrayNodePropertyValues {
    private final long nodeCount;
    private final HugeSparseFloatArrayList floatArrayList;

    public UpdatableFloatArrayNodeProperty(long nodeCount, float[] defaultValue) {
        this.nodeCount = nodeCount;
        this.floatArrayList = HugeSparseFloatArrayList.of((float[])defaultValue);
    }

    public long nodeCount() {
        return this.nodeCount;
    }

    public float[] floatArrayValue(long nodeId) {
        return (float[])this.floatArrayList.get(nodeId);
    }

    @Override
    public void updatePropertyValue(long nodeId, Value value) {
        this.floatArrayList.set(nodeId, (Object)Neo4jValueConversion.getFloatArray((Value)value));
    }
}

