/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.api.CSRGraph;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.Topology;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.token.TokenHolders;

public final class RelationshipIds
extends CypherGraphStore.StateVisitor.Adapter {
    private final GraphStore graphStore;
    private final TokenHolders tokenHolders;
    private final List<RelationshipIdContext> relationshipIdContexts;
    private final List<UpdateListener> updateListeners;
    private final Lock lock;

    static RelationshipIds fromGraphStore(GraphStore graphStore, TokenHolders tokenHolders) {
        ArrayList<RelationshipIdContext> relationshipIdContexts = new ArrayList<RelationshipIdContext>(graphStore.relationshipTypes().size());
        graphStore.relationshipTypes().stream().map(relType -> RelationshipIds.relationshipIdContextFromRelType(graphStore, tokenHolders, relType)).forEach(relationshipIdContexts::add);
        return new RelationshipIds(graphStore, tokenHolders, relationshipIdContexts);
    }

    private RelationshipIds(GraphStore graphStore, TokenHolders tokenHolders, List<RelationshipIdContext> relationshipIdContexts) {
        this.graphStore = graphStore;
        this.tokenHolders = tokenHolders;
        this.relationshipIdContexts = relationshipIdContexts;
        this.updateListeners = new ArrayList<UpdateListener>();
        this.lock = new ReentrantLock();
    }

    public <T> T resolveRelationshipId(long relationshipId, ResolvedRelationshipIdFunction<T> relationshipIdConsumer) {
        long graphLocalRelationshipId = relationshipId;
        for (RelationshipIdContext relationshipIdContext : this.relationshipIdContexts) {
            if (graphLocalRelationshipId >= relationshipIdContext.relationshipCount()) {
                graphLocalRelationshipId -= relationshipIdContext.relationshipCount();
                continue;
            }
            long nodeId = relationshipIdContext.offsets().binarySearch(graphLocalRelationshipId);
            long offsetInAdjacency = graphLocalRelationshipId - relationshipIdContext.offsets().get(nodeId);
            return relationshipIdConsumer.accept(nodeId, offsetInAdjacency, relationshipIdContext);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No relationship with id %d was found.", (Object[])new Object[]{relationshipId}));
    }

    public void registerUpdateListener(UpdateListener updateListener) {
        try {
            this.lock.lock();
            this.updateListeners.add(updateListener);
        }
        finally {
            this.lock.unlock();
        }
        this.relationshipIdContexts.forEach(updateListener::onRelationshipIdsAdded);
    }

    public void removeUpdateListener(UpdateListener updateListener) {
        try {
            this.lock.lock();
            this.updateListeners.remove(updateListener);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void relationshipTypeAdded(String relationshipType) {
        RelationshipIdContext relationshipIdContext = RelationshipIds.relationshipIdContextFromRelType(this.graphStore, this.tokenHolders, RelationshipType.of((String)relationshipType));
        this.relationshipIdContexts.add(relationshipIdContext);
        try {
            this.lock.lock();
            this.updateListeners.forEach(updateListener -> updateListener.onRelationshipIdsAdded(relationshipIdContext));
        }
        finally {
            this.lock.unlock();
        }
    }

    @NotNull
    private static RelationshipIdContext relationshipIdContextFromRelType(GraphStore graphStore, TokenHolders tokenHolders, RelationshipType relType) {
        long relCount = graphStore.relationshipCount(relType);
        CSRGraph graph = (CSRGraph)graphStore.getGraph(new RelationshipType[]{relType});
        HugeLongArray offsets = RelationshipIds.computeAccumulatedOffsets((Graph)graph);
        int relTypeId = tokenHolders.relationshipTypeTokens().getIdByName(relType.name);
        List relationshipProperties = graphStore.relationshipPropertyKeys(relType).stream().map(relProperty -> graphStore.relationshipPropertyValues(relType, relProperty)).collect(Collectors.toList());
        int[] propertyIds = relationshipProperties.stream().mapToInt(relationshipProperty -> tokenHolders.propertyKeyTokens().getIdByName(relationshipProperty.key())).toArray();
        AdjacencyProperties[] adjacencyProperties = (AdjacencyProperties[])relationshipProperties.stream().map(relationshipProperty -> relationshipProperty.values().propertiesList()).toArray(AdjacencyProperties[]::new);
        return new RelationshipIdContext(relType, relTypeId, relCount, graph, offsets, propertyIds, adjacencyProperties);
    }

    private static HugeLongArray computeAccumulatedOffsets(Graph graph) {
        HugeLongArray offsets = HugeLongArray.newArray((long)graph.nodeCount());
        long offset = 0L;
        for (long i = 0L; i < offsets.size(); ++i) {
            offsets.set(i, offset);
            offset += (long)graph.degree(i);
        }
        return offsets;
    }

    public static class RelationshipIdContext {
        private final RelationshipType relationshipType;
        private final int relationshipTypeId;
        private final long relationshipCount;
        private final CSRGraph graph;
        private final HugeLongArray offsets;
        private final int[] propertyIds;
        private final AdjacencyProperties[] adjacencyProperties;
        private final AdjacencyList adjacencyList;

        RelationshipIdContext(RelationshipType relationshipType, int relationshipTypeId, long relationshipCount, CSRGraph graph, HugeLongArray offsets, int[] propertyIds, AdjacencyProperties[] adjacencyProperties) {
            this.relationshipType = relationshipType;
            this.relationshipTypeId = relationshipTypeId;
            this.relationshipCount = relationshipCount;
            this.graph = graph;
            this.offsets = offsets;
            this.propertyIds = propertyIds;
            this.adjacencyProperties = adjacencyProperties;
            this.adjacencyList = ((Topology)this.graph().relationshipTopologies().get(this.relationshipType())).adjacencyList();
        }

        public RelationshipType relationshipType() {
            return this.relationshipType;
        }

        public int relationshipTypeId() {
            return this.relationshipTypeId;
        }

        public long relationshipCount() {
            return this.relationshipCount;
        }

        public CSRGraph graph() {
            return this.graph;
        }

        public HugeLongArray offsets() {
            return this.offsets;
        }

        public int[] propertyIds() {
            return this.propertyIds;
        }

        public AdjacencyProperties[] adjacencyProperties() {
            return this.adjacencyProperties;
        }

        public AdjacencyList adjacencyList() {
            return this.adjacencyList;
        }
    }

    public static interface ResolvedRelationshipIdFunction<T> {
        public T accept(long var1, long var3, RelationshipIdContext var5);
    }

    public static interface UpdateListener {
        public void onRelationshipIdsAdded(RelationshipIdContext var1);
    }
}

