/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.GraphStoreAdapter;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.cypher.CypherIdMap;
import org.neo4j.gds.core.cypher.NodeLabelUpdater;
import org.neo4j.gds.core.cypher.RelationshipIds;
import org.neo4j.gds.core.loading.Capabilities;
import org.neo4j.gds.core.loading.ImmutableStaticCapabilities;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.token.TokenHolders;

public class CypherGraphStore
extends GraphStoreAdapter
implements NodeLabelUpdater {
    private final CypherIdMap cypherIdMap = new CypherIdMap(super.nodes());
    private final List<StateVisitor> stateVisitors = new ArrayList<StateVisitor>();
    private RelationshipIds relationshipIds;

    public CypherGraphStore(GraphStore graphStore) {
        super(graphStore);
    }

    public void initialize(TokenHolders tokenHolders) {
        this.relationshipIds = RelationshipIds.fromGraphStore(this.innerGraphStore(), tokenHolders);
        this.registerStateVisitor(this.relationshipIds);
    }

    public void registerStateVisitor(StateVisitor stateVisitor) {
        this.stateVisitors.add(stateVisitor);
    }

    public Capabilities capabilities() {
        return ImmutableStaticCapabilities.builder().from(super.capabilities()).canWriteToDatabase(false).build();
    }

    public IdMap nodes() {
        return this.cypherIdMap;
    }

    @Override
    public void addNodeLabel(NodeLabel nodeLabel) {
        this.cypherIdMap.addNodeLabel(nodeLabel);
    }

    @Override
    public void addLabelToNode(long nodeId, NodeLabel nodeLabel) {
        this.cypherIdMap.addLabelToNode(nodeId, nodeLabel);
    }

    @Override
    public void removeLabelFromNode(long nodeId, NodeLabel nodeLabel) {
        this.cypherIdMap.removeLabelFromNode(nodeId, nodeLabel);
    }

    public Set<NodeLabel> nodeLabels() {
        return this.cypherIdMap.availableNodeLabels();
    }

    public void removeNodeProperty(String propertyKey) {
        super.removeNodeProperty(propertyKey);
        this.stateVisitors.forEach(stateVisitor -> stateVisitor.nodePropertyRemoved(propertyKey));
    }

    public void addNodeProperty(Set<NodeLabel> nodeLabels, String propertyKey, NodePropertyValues propertyValues) {
        super.addNodeProperty(nodeLabels, propertyKey, propertyValues);
        this.stateVisitors.forEach(stateVisitor -> stateVisitor.nodePropertyAdded(propertyKey));
    }

    public void addRelationshipType(SingleTypeRelationships relationships) {
        this.innerGraphStore().addRelationshipType(relationships);
        relationships.properties().ifPresent(properties -> properties.keySet().forEach(propertyKey -> this.stateVisitors.forEach(stateVisitor -> stateVisitor.relationshipPropertyAdded((String)propertyKey))));
        RelationshipType relType = relationships.relationshipSchemaEntry().identifier();
        this.stateVisitors.forEach(stateVisitor -> stateVisitor.relationshipTypeAdded(relType.name));
    }

    public RelationshipIds relationshipIds() {
        return this.relationshipIds;
    }

    public static interface StateVisitor {
        public void nodePropertyRemoved(String var1);

        public void nodePropertyAdded(String var1);

        public void nodeLabelAdded(String var1);

        public void relationshipTypeAdded(String var1);

        public void relationshipPropertyAdded(String var1);

        public static class Adapter
        implements StateVisitor {
            @Override
            public void nodePropertyRemoved(String propertyKey) {
            }

            @Override
            public void nodePropertyAdded(String propertyKey) {
            }

            @Override
            public void nodeLabelAdded(String nodeLabel) {
            }

            @Override
            public void relationshipTypeAdded(String relationshipType) {
            }

            @Override
            public void relationshipPropertyAdded(String relationshipProperty) {
            }
        }
    }
}

