/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher.nodeproperties;

import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.collections.HugeSparseLongList;
import org.neo4j.gds.core.cypher.UpdatableNodeProperty;
import org.neo4j.gds.utils.Neo4jValueConversion;
import org.neo4j.values.storable.Value;

public class UpdatableLongNodeProperty
implements UpdatableNodeProperty,
LongNodePropertyValues {
    private final long nodeCount;
    private final HugeSparseLongList longList;

    public UpdatableLongNodeProperty(long nodeCount, long defaultValue) {
        this.nodeCount = nodeCount;
        this.longList = HugeSparseLongList.of((long)defaultValue);
    }

    public long nodeCount() {
        return this.nodeCount;
    }

    public long longValue(long nodeId) {
        return this.longList.get(nodeId);
    }

    @Override
    public void updatePropertyValue(long nodeId, Value value) {
        this.longList.set(nodeId, Neo4jValueConversion.getLongValue((Value)value));
    }
}

