/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher.nodeproperties;

import org.neo4j.gds.api.properties.nodes.LongArrayNodePropertyValues;
import org.neo4j.gds.collections.HugeSparseLongArrayList;
import org.neo4j.gds.core.cypher.UpdatableNodeProperty;
import org.neo4j.gds.utils.Neo4jValueConversion;
import org.neo4j.values.storable.Value;

public class UpdatableLongArrayNodeProperty
implements UpdatableNodeProperty,
LongArrayNodePropertyValues {
    private final long nodeCount;
    private final HugeSparseLongArrayList longArrayList;

    public UpdatableLongArrayNodeProperty(long nodeCount, long[] defaultValue) {
        this.nodeCount = nodeCount;
        this.longArrayList = HugeSparseLongArrayList.of((long[])defaultValue);
    }

    public long nodeCount() {
        return this.nodeCount;
    }

    public long[] longArrayValue(long nodeId) {
        return (long[])this.longArrayList.get(nodeId);
    }

    @Override
    public void updatePropertyValue(long nodeId, Value value) {
        this.longArrayList.set(nodeId, (Object)Neo4jValueConversion.getLongArray((Value)value));
    }
}

