/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher.nodeproperties;

import org.neo4j.gds.api.properties.nodes.DoubleNodePropertyValues;
import org.neo4j.gds.collections.HugeSparseDoubleList;
import org.neo4j.gds.core.cypher.UpdatableNodeProperty;
import org.neo4j.gds.utils.Neo4jValueConversion;
import org.neo4j.values.storable.Value;

public class UpdatableDoubleNodeProperty
implements UpdatableNodeProperty,
DoubleNodePropertyValues {
    private final long nodeCount;
    private final HugeSparseDoubleList doubleList;

    public UpdatableDoubleNodeProperty(long nodeCount, double defaultValue) {
        this.nodeCount = nodeCount;
        this.doubleList = HugeSparseDoubleList.of((double)defaultValue);
    }

    public long size() {
        return this.nodeCount;
    }

    public double doubleValue(long nodeId) {
        return this.doubleList.get(nodeId);
    }

    @Override
    public void updatePropertyValue(long nodeId, Value value) {
        this.doubleList.set(nodeId, Neo4jValueConversion.getDoubleValue((Value)value));
    }
}

