/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.api.CSRGraph;
import org.neo4j.gds.core.cypher.RelationshipIds;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

@Generated(from="RelationshipIds.RelationshipIdContext", generator="Immutables")
public final class ImmutableRelationshipIdContext
implements RelationshipIds.RelationshipIdContext {
    private final RelationshipType relationshipType;
    private final int relationshipTypeId;
    private final long relationshipCount;
    private final CSRGraph graph;
    private final HugeLongArray offsets;
    private final int[] propertyIds;
    private final AdjacencyProperties[] adjacencyProperties;
    private final transient AdjacencyList adjacencyList;

    private ImmutableRelationshipIdContext(RelationshipType relationshipType, int relationshipTypeId, long relationshipCount, CSRGraph graph, HugeLongArray offsets, int[] propertyIds, AdjacencyProperties[] adjacencyProperties) {
        this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
        this.relationshipTypeId = relationshipTypeId;
        this.relationshipCount = relationshipCount;
        this.graph = Objects.requireNonNull(graph, "graph");
        this.offsets = Objects.requireNonNull(offsets, "offsets");
        this.propertyIds = (int[])propertyIds.clone();
        this.adjacencyProperties = (AdjacencyProperties[])adjacencyProperties.clone();
        this.adjacencyList = Objects.requireNonNull(RelationshipIds.RelationshipIdContext.super.adjacencyList(), "adjacencyList");
    }

    private ImmutableRelationshipIdContext(ImmutableRelationshipIdContext original, RelationshipType relationshipType, int relationshipTypeId, long relationshipCount, CSRGraph graph, HugeLongArray offsets, int[] propertyIds, AdjacencyProperties[] adjacencyProperties) {
        this.relationshipType = relationshipType;
        this.relationshipTypeId = relationshipTypeId;
        this.relationshipCount = relationshipCount;
        this.graph = graph;
        this.offsets = offsets;
        this.propertyIds = propertyIds;
        this.adjacencyProperties = adjacencyProperties;
        this.adjacencyList = Objects.requireNonNull(RelationshipIds.RelationshipIdContext.super.adjacencyList(), "adjacencyList");
    }

    @Override
    public RelationshipType relationshipType() {
        return this.relationshipType;
    }

    @Override
    public int relationshipTypeId() {
        return this.relationshipTypeId;
    }

    @Override
    public long relationshipCount() {
        return this.relationshipCount;
    }

    @Override
    public CSRGraph graph() {
        return this.graph;
    }

    @Override
    public HugeLongArray offsets() {
        return this.offsets;
    }

    @Override
    public int[] propertyIds() {
        return (int[])this.propertyIds.clone();
    }

    @Override
    public AdjacencyProperties[] adjacencyProperties() {
        return (AdjacencyProperties[])this.adjacencyProperties.clone();
    }

    @Override
    public AdjacencyList adjacencyList() {
        return this.adjacencyList;
    }

    public final ImmutableRelationshipIdContext withRelationshipType(RelationshipType value) {
        if (this.relationshipType == value) {
            return this;
        }
        RelationshipType newValue = Objects.requireNonNull(value, "relationshipType");
        return new ImmutableRelationshipIdContext(this, newValue, this.relationshipTypeId, this.relationshipCount, this.graph, this.offsets, this.propertyIds, this.adjacencyProperties);
    }

    public final ImmutableRelationshipIdContext withRelationshipTypeId(int value) {
        if (this.relationshipTypeId == value) {
            return this;
        }
        return new ImmutableRelationshipIdContext(this, this.relationshipType, value, this.relationshipCount, this.graph, this.offsets, this.propertyIds, this.adjacencyProperties);
    }

    public final ImmutableRelationshipIdContext withRelationshipCount(long value) {
        if (this.relationshipCount == value) {
            return this;
        }
        return new ImmutableRelationshipIdContext(this, this.relationshipType, this.relationshipTypeId, value, this.graph, this.offsets, this.propertyIds, this.adjacencyProperties);
    }

    public final ImmutableRelationshipIdContext withGraph(CSRGraph value) {
        if (this.graph == value) {
            return this;
        }
        CSRGraph newValue = Objects.requireNonNull(value, "graph");
        return new ImmutableRelationshipIdContext(this, this.relationshipType, this.relationshipTypeId, this.relationshipCount, newValue, this.offsets, this.propertyIds, this.adjacencyProperties);
    }

    public final ImmutableRelationshipIdContext withOffsets(HugeLongArray value) {
        if (this.offsets == value) {
            return this;
        }
        HugeLongArray newValue = Objects.requireNonNull(value, "offsets");
        return new ImmutableRelationshipIdContext(this, this.relationshipType, this.relationshipTypeId, this.relationshipCount, this.graph, newValue, this.propertyIds, this.adjacencyProperties);
    }

    public final ImmutableRelationshipIdContext withPropertyIds(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutableRelationshipIdContext(this, this.relationshipType, this.relationshipTypeId, this.relationshipCount, this.graph, this.offsets, newValue, this.adjacencyProperties);
    }

    public final ImmutableRelationshipIdContext withAdjacencyProperties(AdjacencyProperties ... elements) {
        AdjacencyProperties[] newValue = (AdjacencyProperties[])elements.clone();
        return new ImmutableRelationshipIdContext(this, this.relationshipType, this.relationshipTypeId, this.relationshipCount, this.graph, this.offsets, this.propertyIds, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationshipIdContext && this.equalTo((ImmutableRelationshipIdContext)another);
    }

    private boolean equalTo(ImmutableRelationshipIdContext another) {
        return this.relationshipType.equals((Object)another.relationshipType) && this.relationshipTypeId == another.relationshipTypeId && this.relationshipCount == another.relationshipCount && this.graph.equals(another.graph) && this.offsets.equals(another.offsets) && Arrays.equals(this.propertyIds, another.propertyIds) && Arrays.equals(this.adjacencyProperties, another.adjacencyProperties) && this.adjacencyList.equals(another.adjacencyList);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relationshipType.hashCode();
        h += (h << 5) + this.relationshipTypeId;
        h += (h << 5) + Long.hashCode(this.relationshipCount);
        h += (h << 5) + this.graph.hashCode();
        h += (h << 5) + this.offsets.hashCode();
        h += (h << 5) + Arrays.hashCode(this.propertyIds);
        h += (h << 5) + Arrays.hashCode(this.adjacencyProperties);
        h += (h << 5) + this.adjacencyList.hashCode();
        return h;
    }

    public String toString() {
        return "RelationshipIdContext{relationshipType=" + this.relationshipType + ", relationshipTypeId=" + this.relationshipTypeId + ", relationshipCount=" + this.relationshipCount + ", graph=" + this.graph + ", offsets=" + this.offsets + ", propertyIds=" + Arrays.toString(this.propertyIds) + ", adjacencyProperties=" + Arrays.toString(this.adjacencyProperties) + ", adjacencyList=" + this.adjacencyList + "}";
    }

    public static RelationshipIds.RelationshipIdContext of(RelationshipType relationshipType, int relationshipTypeId, long relationshipCount, CSRGraph graph, HugeLongArray offsets, int[] propertyIds, AdjacencyProperties[] adjacencyProperties) {
        return new ImmutableRelationshipIdContext(relationshipType, relationshipTypeId, relationshipCount, graph, offsets, propertyIds, adjacencyProperties);
    }

    public static RelationshipIds.RelationshipIdContext copyOf(RelationshipIds.RelationshipIdContext instance) {
        if (instance instanceof ImmutableRelationshipIdContext) {
            return (ImmutableRelationshipIdContext)instance;
        }
        return ImmutableRelationshipIdContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RelationshipIds.RelationshipIdContext", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_RELATIONSHIP_TYPE = 1L;
        private static final long INIT_BIT_RELATIONSHIP_TYPE_ID = 2L;
        private static final long INIT_BIT_RELATIONSHIP_COUNT = 4L;
        private static final long INIT_BIT_GRAPH = 8L;
        private static final long INIT_BIT_OFFSETS = 16L;
        private static final long INIT_BIT_PROPERTY_IDS = 32L;
        private static final long INIT_BIT_ADJACENCY_PROPERTIES = 64L;
        private long initBits = 127L;
        private RelationshipType relationshipType;
        private int relationshipTypeId;
        private long relationshipCount;
        private CSRGraph graph;
        private HugeLongArray offsets;
        private int[] propertyIds;
        private AdjacencyProperties[] adjacencyProperties;

        private Builder() {
        }

        public final Builder from(RelationshipIds.RelationshipIdContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.relationshipType(instance.relationshipType());
            this.relationshipTypeId(instance.relationshipTypeId());
            this.relationshipCount(instance.relationshipCount());
            this.graph(instance.graph());
            this.offsets(instance.offsets());
            this.propertyIds(instance.propertyIds());
            this.adjacencyProperties(instance.adjacencyProperties());
            return this;
        }

        public final Builder relationshipType(RelationshipType relationshipType) {
            this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipTypeId(int relationshipTypeId) {
            this.relationshipTypeId = relationshipTypeId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder relationshipCount(long relationshipCount) {
            this.relationshipCount = relationshipCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder graph(CSRGraph graph) {
            this.graph = Objects.requireNonNull(graph, "graph");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder offsets(HugeLongArray offsets) {
            this.offsets = Objects.requireNonNull(offsets, "offsets");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder propertyIds(int ... propertyIds) {
            this.propertyIds = (int[])propertyIds.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder adjacencyProperties(AdjacencyProperties ... adjacencyProperties) {
            this.adjacencyProperties = (AdjacencyProperties[])adjacencyProperties.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 127L;
            this.relationshipType = null;
            this.relationshipTypeId = 0;
            this.relationshipCount = 0L;
            this.graph = null;
            this.offsets = null;
            this.propertyIds = null;
            this.adjacencyProperties = null;
            return this;
        }

        public RelationshipIds.RelationshipIdContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelationshipIdContext(null, this.relationshipType, this.relationshipTypeId, this.relationshipCount, this.graph, this.offsets, this.propertyIds, this.adjacencyProperties);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relationshipType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relationshipTypeId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("relationshipCount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("graph");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("offsets");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("propertyIds");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("adjacencyProperties");
            }
            return "Cannot build RelationshipIdContext, some of required attributes are not set " + attributes;
        }
    }
}

