/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher.nodeproperties;

import org.neo4j.gds.api.properties.nodes.DoubleArrayNodePropertyValues;
import org.neo4j.gds.collections.HugeSparseDoubleArrayList;
import org.neo4j.gds.core.cypher.UpdatableNodeProperty;
import org.neo4j.gds.utils.Neo4jValueConversion;
import org.neo4j.values.storable.Value;

public class UpdatableDoubleArrayNodeProperty
implements UpdatableNodeProperty,
DoubleArrayNodePropertyValues {
    private final long nodeCount;
    private final HugeSparseDoubleArrayList doubleArrayList;

    public UpdatableDoubleArrayNodeProperty(long nodeCount, double[] defaultValue) {
        this.nodeCount = nodeCount;
        this.doubleArrayList = HugeSparseDoubleArrayList.of((double[])defaultValue);
    }

    public long size() {
        return this.nodeCount;
    }

    public double[] doubleArrayValue(long nodeId) {
        return this.doubleArrayList.get(nodeId);
    }

    @Override
    public void updatePropertyValue(long nodeId, Value value) {
        this.doubleArrayList.set(nodeId, Neo4jValueConversion.getDoubleArray((Value)value));
    }
}

