/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.api.CSRGraph;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.gds.core.cypher.ImmutableRelationshipIdContext;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.token.TokenHolders;

public final class RelationshipIds
extends CypherGraphStore.StateVisitor.Adapter {
    private final GraphStore graphStore;
    private final TokenHolders tokenHolders;
    private final List<RelationshipIdContext> relationshipIdContexts;
    private final List<UpdateListener> updateListeners;

    static RelationshipIds fromGraphStore(GraphStore graphStore, TokenHolders tokenHolders) {
        ArrayList<RelationshipIdContext> relationshipIdContexts = new ArrayList<RelationshipIdContext>(graphStore.relationshipTypes().size());
        graphStore.relationshipTypes().stream().map(relType -> RelationshipIds.relationshipIdContextFromRelType(graphStore, tokenHolders, relType)).forEach(relationshipIdContexts::add);
        return new RelationshipIds(graphStore, tokenHolders, relationshipIdContexts);
    }

    private RelationshipIds(GraphStore graphStore, TokenHolders tokenHolders, List<RelationshipIdContext> relationshipIdContexts) {
        this.graphStore = graphStore;
        this.tokenHolders = tokenHolders;
        this.relationshipIdContexts = relationshipIdContexts;
        this.updateListeners = new ArrayList<UpdateListener>();
    }

    public <T> T resolveRelationshipId(long relationshipId, ResolvedRelationshipIdFunction<T> relationshipIdConsumer) {
        long graphLocalRelationshipId = relationshipId;
        for (RelationshipIdContext relationshipIdContext : this.relationshipIdContexts) {
            if (graphLocalRelationshipId >= relationshipIdContext.relationshipCount()) {
                graphLocalRelationshipId -= relationshipIdContext.relationshipCount();
                continue;
            }
            long nodeId = relationshipIdContext.offsets().binarySearch(graphLocalRelationshipId);
            long offsetInAdjacency = graphLocalRelationshipId - relationshipIdContext.offsets().get(nodeId);
            return relationshipIdConsumer.accept(nodeId, offsetInAdjacency, relationshipIdContext);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No relationship with id %d was found.", (Object[])new Object[]{relationshipId}));
    }

    public void registerUpdateListener(UpdateListener updateListener) {
        this.updateListeners.add(updateListener);
        this.relationshipIdContexts.forEach(updateListener::onRelationshipIdsAdded);
    }

    @Override
    public void relationshipTypeAdded(String relationshipType) {
        RelationshipIdContext relationshipIdContext = RelationshipIds.relationshipIdContextFromRelType(this.graphStore, this.tokenHolders, RelationshipType.of((String)relationshipType));
        this.relationshipIdContexts.add(relationshipIdContext);
        this.updateListeners.forEach(updateListener -> updateListener.onRelationshipIdsAdded(relationshipIdContext));
    }

    @NotNull
    private static RelationshipIdContext relationshipIdContextFromRelType(GraphStore graphStore, TokenHolders tokenHolders, RelationshipType relType) {
        long relCount = graphStore.relationshipCount(relType);
        CSRGraph graph = (CSRGraph)graphStore.getGraph(new RelationshipType[]{relType});
        HugeLongArray offsets = RelationshipIds.computeAccumulatedOffsets((Graph)graph);
        int relTypeId = tokenHolders.relationshipTypeTokens().getIdByName(relType.name);
        List relationshipProperties = graphStore.relationshipPropertyKeys(relType).stream().map(relProperty -> graphStore.relationshipPropertyValues(relType, relProperty)).collect(Collectors.toList());
        int[] propertyIds = relationshipProperties.stream().mapToInt(relationshipProperty -> tokenHolders.propertyKeyTokens().getIdByName(relationshipProperty.key())).toArray();
        AdjacencyProperties[] adjacencyProperties = (AdjacencyProperties[])relationshipProperties.stream().map(relationshipProperty -> relationshipProperty.values().propertiesList()).toArray(AdjacencyProperties[]::new);
        return ImmutableRelationshipIdContext.of(relType, relTypeId, relCount, graph, offsets, propertyIds, adjacencyProperties);
    }

    private static HugeLongArray computeAccumulatedOffsets(Graph graph) {
        HugeLongArray offsets = HugeLongArray.newArray((long)graph.nodeCount());
        long offset = 0L;
        for (long i = 0L; i < offsets.size(); ++i) {
            offsets.set(i, offset);
            offset += (long)graph.degree(i);
        }
        return offsets;
    }

    @ValueClass
    public static interface RelationshipIdContext {
        public RelationshipType relationshipType();

        public int relationshipTypeId();

        public long relationshipCount();

        public CSRGraph graph();

        public HugeLongArray offsets();

        public int[] propertyIds();

        public AdjacencyProperties[] adjacencyProperties();

        @Value.Derived
        default public AdjacencyList adjacencyList() {
            return ((Relationships.Topology)this.graph().relationshipTopologies().get(this.relationshipType())).adjacencyList();
        }
    }

    public static interface ResolvedRelationshipIdFunction<T> {
        public T accept(long var1, long var3, RelationshipIdContext var5);
    }

    public static interface UpdateListener {
        public void onRelationshipIdsAdded(RelationshipIdContext var1);
    }
}

