/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import com.carrotsearch.hppc.BitSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.IdMapAdapter;
import org.neo4j.gds.core.cypher.NodeLabelUpdater;
import org.neo4j.gds.utils.StringFormatting;

public class CypherIdMap
extends IdMapAdapter
implements NodeLabelUpdater {
    private final Map<NodeLabel, BitSet> additionalNodeLabels = new HashMap<NodeLabel, BitSet>();

    CypherIdMap(IdMap idMap) {
        super(idMap);
    }

    @Override
    public void addNodeLabel(NodeLabel nodeLabel) {
        this.additionalNodeLabels.put(nodeLabel, new BitSet(this.nodeCount()));
    }

    @Override
    public void addLabelToNode(long nodeId, NodeLabel nodeLabel) {
        this.additionalNodeLabels.computeIfAbsent(nodeLabel, ignore -> new BitSet(this.nodeCount()));
        this.additionalNodeLabels.get(nodeLabel).set(nodeId);
    }

    @Override
    public void removeLabelFromNode(long nodeId, NodeLabel nodeLabel) {
        BitSet nodeLabelBitSet = this.additionalNodeLabels.get(nodeLabel);
        if (nodeLabelBitSet == null) {
            throw new RuntimeException(StringFormatting.formatWithLocale((String)"Could not find updatable label with name `%s`", (Object[])new Object[]{nodeLabel.name()}));
        }
        nodeLabelBitSet.clear(nodeId);
    }

    public List<NodeLabel> nodeLabels(long mappedNodeId) {
        ArrayList<NodeLabel> nodeLabels = new ArrayList<NodeLabel>(super.nodeLabels(mappedNodeId));
        this.additionalNodeLabels.forEach((nodeLabel, bitSet) -> {
            if (bitSet.get(mappedNodeId)) {
                nodeLabels.add((NodeLabel)nodeLabel);
            }
        });
        return nodeLabels;
    }

    public void forEachNodeLabel(long mappedNodeId, IdMap.NodeLabelConsumer consumer) {
        super.forEachNodeLabel(mappedNodeId, consumer);
        for (Map.Entry<NodeLabel, BitSet> entry : this.additionalNodeLabels.entrySet()) {
            NodeLabel nodeLabel = entry.getKey();
            BitSet bitSet = entry.getValue();
            if (!bitSet.get(mappedNodeId) || consumer.accept(nodeLabel)) continue;
            break;
        }
    }

    public Set<NodeLabel> availableNodeLabels() {
        HashSet<NodeLabel> nodeLabels = new HashSet<NodeLabel>(super.availableNodeLabels());
        nodeLabels.addAll(this.additionalNodeLabels.keySet());
        return nodeLabels;
    }

    public boolean hasLabel(long mappedNodeId, NodeLabel nodeLabel) {
        boolean hasLoadedLabel = super.hasLabel(mappedNodeId, nodeLabel);
        if (!hasLoadedLabel) {
            if (this.additionalNodeLabels.containsKey(nodeLabel)) {
                return this.additionalNodeLabels.get(nodeLabel).get(mappedNodeId);
            }
            return false;
        }
        return true;
    }
}

