/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.GraphStoreWrapper;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.loading.CatalogRequest;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.kernel.database.NamedDatabaseId;

public final class CypherGraphStoreCatalogHelper {
    private CypherGraphStoreCatalogHelper() {
    }

    public static void setWrappedGraphStore(GraphProjectConfig config, GraphStoreWrapper graphStoreWrapper) {
        String graphName;
        CatalogRequest catalogRequest = CatalogRequest.of((String)config.username(), (NamedDatabaseId)graphStoreWrapper.databaseId());
        GraphStore graphStore = GraphStoreCatalog.get((CatalogRequest)catalogRequest, (String)(graphName = config.graphName())).graphStore();
        if (graphStore != graphStoreWrapper.innerGraphStore()) {
            throw new IllegalArgumentException("Attempted to override a graph store with an incompatible graph store wrapper.");
        }
        GraphStoreCatalog.overwrite((GraphProjectConfig)config, (GraphStore)graphStoreWrapper);
    }
}

