/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.CompositeRelationshipIterator;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.NodeProperty;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.RelationshipProperty;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.core.cypher.GraphStoreWrapper;
import org.neo4j.gds.core.loading.DeletionResult;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.storable.NumberType;

public abstract class GraphStoreAdapter
implements GraphStoreWrapper {
    private final GraphStore graphStore;

    protected GraphStoreAdapter(GraphStore graphStore) {
        this.graphStore = graphStore;
    }

    @Override
    public GraphStore innerGraphStore() {
        return this.graphStore;
    }

    public NamedDatabaseId databaseId() {
        return this.graphStore.databaseId();
    }

    public GraphSchema schema() {
        return this.graphStore.schema();
    }

    public ZonedDateTime modificationTime() {
        return this.graphStore.modificationTime();
    }

    public long nodeCount() {
        return this.graphStore.nodeCount();
    }

    public IdMap nodes() {
        return this.graphStore.nodes();
    }

    public Set<NodeLabel> nodeLabels() {
        return this.graphStore.nodeLabels();
    }

    public Set<String> nodePropertyKeys(NodeLabel label) {
        return this.graphStore.nodePropertyKeys(label);
    }

    public Map<NodeLabel, Set<String>> nodePropertyKeys() {
        return this.graphStore.nodePropertyKeys();
    }

    public boolean hasNodeProperty(NodeLabel label, String propertyKey) {
        return this.graphStore.hasNodeProperty(label, propertyKey);
    }

    public boolean hasNodeProperty(Collection<NodeLabel> labels, String propertyKey) {
        return this.graphStore.hasNodeProperty(labels, propertyKey);
    }

    public Collection<String> nodePropertyKeys(Collection<NodeLabel> labels) {
        return this.graphStore.nodePropertyKeys(labels);
    }

    public NodeProperty nodeProperty(NodeLabel label, String propertyKey) {
        return this.graphStore.nodeProperty(label, propertyKey);
    }

    public NodeProperty nodeProperty(String propertyKey) {
        return this.graphStore.nodeProperty(propertyKey);
    }

    public ValueType nodePropertyType(NodeLabel label, String propertyKey) {
        return this.graphStore.nodePropertyType(label, propertyKey);
    }

    public PropertyState nodePropertyState(String propertyKey) {
        return this.graphStore.nodePropertyState(propertyKey);
    }

    public NodeProperties nodePropertyValues(String propertyKey) {
        return this.graphStore.nodePropertyValues(propertyKey);
    }

    public NodeProperties nodePropertyValues(NodeLabel label, String propertyKey) {
        return this.graphStore.nodePropertyValues(label, propertyKey);
    }

    public void addNodeProperty(NodeLabel nodeLabel, String propertyKey, NodeProperties propertyValues) {
        this.graphStore.addNodeProperty(nodeLabel, propertyKey, propertyValues);
    }

    public void removeNodeProperty(NodeLabel nodeLabel, String propertyKey) {
        this.graphStore.removeNodeProperty(nodeLabel, propertyKey);
    }

    public long relationshipCount() {
        return this.graphStore.relationshipCount();
    }

    public long relationshipCount(RelationshipType relationshipType) {
        return this.graphStore.relationshipCount(relationshipType);
    }

    public Set<RelationshipType> relationshipTypes() {
        return this.graphStore.relationshipTypes();
    }

    public boolean hasRelationshipType(RelationshipType relationshipType) {
        return this.graphStore.hasRelationshipType(relationshipType);
    }

    public boolean hasRelationshipProperty(RelationshipType relType, String propertyKey) {
        return this.graphStore.hasRelationshipProperty(relType, propertyKey);
    }

    public Collection<String> relationshipPropertyKeys(Collection<RelationshipType> relTypes) {
        return this.graphStore.relationshipPropertyKeys(relTypes);
    }

    public ValueType relationshipPropertyType(String propertyKey) {
        return this.graphStore.relationshipPropertyType(propertyKey);
    }

    public Set<String> relationshipPropertyKeys() {
        return this.graphStore.relationshipPropertyKeys();
    }

    public Set<String> relationshipPropertyKeys(RelationshipType relationshipType) {
        return this.graphStore.relationshipPropertyKeys(relationshipType);
    }

    public RelationshipProperty relationshipPropertyValues(RelationshipType relationshipType, String propertyKey) {
        return this.graphStore.relationshipPropertyValues(relationshipType, propertyKey);
    }

    public void addRelationshipType(RelationshipType relationshipType, Optional<String> relationshipPropertyKey, Optional<NumberType> relationshipPropertyType, Relationships relationships) {
        this.graphStore.addRelationshipType(relationshipType, relationshipPropertyKey, relationshipPropertyType, relationships);
    }

    public DeletionResult deleteRelationships(RelationshipType relationshipType) {
        return this.graphStore.deleteRelationships(relationshipType);
    }

    public Graph getGraph(RelationshipType ... relationshipType) {
        return this.graphStore.getGraph(relationshipType);
    }

    public Graph getGraph(RelationshipType relationshipType, Optional<String> relationshipProperty) {
        return this.graphStore.getGraph(relationshipType, relationshipProperty);
    }

    public Graph getGraph(Collection<RelationshipType> relationshipTypes, Optional<String> maybeRelationshipProperty) {
        return this.graphStore.getGraph(relationshipTypes, maybeRelationshipProperty);
    }

    public Graph getGraph(String nodeLabel, String relationshipType, Optional<String> maybeRelationshipProperty) {
        return this.graphStore.getGraph(nodeLabel, relationshipType, maybeRelationshipProperty);
    }

    public Graph getGraph(NodeLabel nodeLabel, RelationshipType relationshipType, Optional<String> maybeRelationshipProperty) {
        return this.graphStore.getGraph(nodeLabel, relationshipType, maybeRelationshipProperty);
    }

    public Graph getGraph(Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes, Optional<String> maybeRelationshipProperty) {
        return this.graphStore.getGraph(nodeLabels, relationshipTypes, maybeRelationshipProperty);
    }

    public Graph getUnion() {
        return this.graphStore.getUnion();
    }

    public CompositeRelationshipIterator getCompositeRelationshipIterator(RelationshipType relationshipType, List<String> propertyKeys) {
        return this.graphStore.getCompositeRelationshipIterator(relationshipType, propertyKeys);
    }

    public void canRelease(boolean canRelease) {
        this.graphStore.canRelease(canRelease);
    }

    public void release() {
        this.graphStore.release();
    }
}

