/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import com.carrotsearch.hppc.BitSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.cypher.IdMapAdapter;
import org.neo4j.gds.core.cypher.NodeLabelUpdater;

public class CypherIdMap
extends IdMapAdapter
implements NodeLabelUpdater {
    private final Map<NodeLabel, BitSet> additionalNodeLabels = new HashMap<NodeLabel, BitSet>();

    CypherIdMap(IdMap idMap) {
        super(idMap);
    }

    @Override
    public void addNodeLabel(NodeLabel nodeLabel) {
        this.additionalNodeLabels.put(nodeLabel, new BitSet(this.nodeCount()));
    }

    @Override
    public void addLabelToNode(long nodeId, NodeLabel nodeLabel) {
        this.additionalNodeLabels.computeIfAbsent(nodeLabel, ignore -> new BitSet(this.nodeCount()));
        this.additionalNodeLabels.get(nodeLabel).set(nodeId);
    }

    @Override
    public List<NodeLabel> nodeLabels(long nodeId) {
        ArrayList<NodeLabel> nodeLabels = new ArrayList<NodeLabel>(super.nodeLabels(nodeId));
        this.additionalNodeLabels.forEach((nodeLabel, bitSet) -> {
            if (bitSet.get(nodeId)) {
                nodeLabels.add((NodeLabel)nodeLabel);
            }
        });
        return nodeLabels;
    }

    @Override
    public void forEachNodeLabel(long nodeId, IdMap.NodeLabelConsumer consumer) {
        super.forEachNodeLabel(nodeId, consumer);
        for (Map.Entry<NodeLabel, BitSet> entry : this.additionalNodeLabels.entrySet()) {
            NodeLabel nodeLabel = entry.getKey();
            BitSet bitSet = entry.getValue();
            if (!bitSet.get(nodeId) || consumer.accept(nodeLabel)) continue;
            break;
        }
    }

    @Override
    public Set<NodeLabel> availableNodeLabels() {
        HashSet<NodeLabel> nodeLabels = new HashSet<NodeLabel>(super.availableNodeLabels());
        nodeLabels.addAll(this.additionalNodeLabels.keySet());
        return nodeLabels;
    }

    @Override
    public boolean hasLabel(long nodeId, NodeLabel nodeLabel) {
        boolean hasLoadedLabel = super.hasLabel(nodeId, nodeLabel);
        if (!hasLoadedLabel) {
            if (this.additionalNodeLabels.containsKey(nodeLabel)) {
                return this.additionalNodeLabels.get(nodeLabel).get(nodeId);
            }
            return false;
        }
        return true;
    }
}

