/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.PropertyCursor;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.core.cypher.CypherRelationshipCursor;
import org.neo4j.gds.core.cypher.ImmutableRelationshipIdContext;
import org.neo4j.gds.core.cypher.RelationshipWithIdCursorIterator;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.token.TokenHolders;

public final class RelationshipIds {
    private final GraphStore graphStore;
    private final List<RelationshipIdContext> relationshipIdContexts;
    private final TokenHolders tokenHolders;

    static RelationshipIds fromGraphStore(GraphStore graphStore, TokenHolders tokenHolders) {
        ArrayList<RelationshipIdContext> relationshipIdContexts = new ArrayList<RelationshipIdContext>();
        graphStore.relationshipTypes().forEach(relType -> {
            long relCount = graphStore.relationshipCount(relType);
            Graph graph = graphStore.getGraph(new RelationshipType[]{relType});
            HugeLongArray offsets = RelationshipIds.computeAccumulatedOffsets(graph);
            relationshipIdContexts.add(ImmutableRelationshipIdContext.of(relType, relCount, graph, offsets));
        });
        return new RelationshipIds(graphStore, relationshipIdContexts, tokenHolders);
    }

    private RelationshipIds(GraphStore graphStore, List<RelationshipIdContext> relationshipIdContexts, TokenHolders tokenHolders) {
        this.graphStore = graphStore;
        this.relationshipIdContexts = relationshipIdContexts;
        this.tokenHolders = tokenHolders;
    }

    public CypherRelationshipCursor relationshipForId(long relationshipId) {
        return this.resolveRelationshipId(relationshipId, (nodeId, offsetInAdjacency, relationshipIdContext) -> relationshipIdContext.graph().streamRelationships(nodeId, Double.NaN).skip(offsetInAdjacency).findFirst().map(relCursor -> CypherRelationshipCursor.fromRelationshipCursor(relCursor, relationshipId, relationshipIdContext.relationshipType())).orElseThrow(() -> new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No relationship with id %d was found for relationship type %s", (Object[])new Object[]{relationshipId, relationshipIdContext.relationshipType()}))));
    }

    public double propertyValueForId(long relationshipId, String propertyKey) {
        return this.resolveRelationshipId(relationshipId, (nodeId, offsetInAdjacency, relationshipIdContext) -> {
            Relationships.Properties properties = this.graphStore.relationshipPropertyValues(relationshipIdContext.relationshipType(), propertyKey).values();
            PropertyCursor propertyCursor = properties.propertiesList().propertyCursor(nodeId);
            int i = 0;
            while ((long)i < offsetInAdjacency - 1L) {
                if (!propertyCursor.hasNextLong()) {
                    return Double.NaN;
                }
                propertyCursor.nextLong();
                ++i;
            }
            if (propertyCursor.hasNextLong()) {
                return Double.longBitsToDouble(propertyCursor.nextLong());
            }
            return Double.NaN;
        });
    }

    public RelationshipType relationshipTypeForId(long relationshipId) {
        return this.resolveRelationshipId(relationshipId, (nodeId, offsetInAdjacency, relationshipIdContext) -> relationshipIdContext.relationshipType());
    }

    public Iterator<CypherRelationshipCursor> relationshipCursors(long nodeId, RelationshipSelection relationshipSelection) {
        Predicate<RelationshipType> relationshipSelectionPredicate = relationshipType -> {
            int relTypeToken = this.tokenHolders.relationshipTypeTokens().getIdByName(relationshipType.name());
            return relationshipSelection.test(relTypeToken);
        };
        return new RelationshipWithIdCursorIterator(this.relationshipIdContexts, nodeId, relationshipSelectionPredicate);
    }

    private <T> T resolveRelationshipId(long relationshipId, ResolvedRelationshipIdFunction<T> relationshipIdConsumer) {
        long graphLocalRelationshipId = relationshipId;
        for (RelationshipIdContext relationshipIdContext : this.relationshipIdContexts) {
            if (graphLocalRelationshipId >= relationshipIdContext.relationshipCount()) {
                graphLocalRelationshipId -= relationshipIdContext.relationshipCount();
                continue;
            }
            long nodeId = relationshipIdContext.offsets().binarySearch(graphLocalRelationshipId);
            long offsetInAdjacency = graphLocalRelationshipId - relationshipIdContext.offsets().get(nodeId);
            return relationshipIdConsumer.accept(nodeId, offsetInAdjacency, relationshipIdContext);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No relationship with id %d was found.", (Object[])new Object[]{relationshipId}));
    }

    private static HugeLongArray computeAccumulatedOffsets(Graph graph) {
        HugeLongArray offsets = HugeLongArray.newArray((long)graph.nodeCount(), (AllocationTracker)AllocationTracker.empty());
        long offset = 0L;
        for (long i = 0L; i < offsets.size(); ++i) {
            offsets.set(i, offset);
            offset += (long)graph.degree(i);
        }
        return offsets;
    }

    @ValueClass
    public static interface RelationshipIdContext {
        public RelationshipType relationshipType();

        public long relationshipCount();

        public Graph graph();

        public HugeLongArray offsets();
    }

    public static interface ResolvedRelationshipIdFunction<T> {
        public T accept(long var1, long var3, RelationshipIdContext var5);
    }
}

