/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.cypher.CypherIdMap;
import org.neo4j.gds.core.cypher.GraphStoreAdapter;
import org.neo4j.gds.core.cypher.NodeLabelUpdater;
import org.neo4j.gds.core.cypher.RelationshipIds;
import org.neo4j.token.TokenHolders;

public class CypherGraphStore
extends GraphStoreAdapter
implements NodeLabelUpdater {
    private final CypherIdMap cypherIdMap = new CypherIdMap(super.nodes());
    private RelationshipIds relationshipIds;

    public CypherGraphStore(GraphStore graphStore) {
        super(graphStore);
    }

    public void initialize(TokenHolders tokenHolders) {
        this.relationshipIds = RelationshipIds.fromGraphStore(this.innerGraphStore(), tokenHolders);
    }

    @Override
    public IdMap nodes() {
        return this.cypherIdMap;
    }

    @Override
    public void addNodeLabel(NodeLabel nodeLabel) {
        this.cypherIdMap.addNodeLabel(nodeLabel);
    }

    @Override
    public void addLabelToNode(long nodeId, NodeLabel nodeLabel) {
        this.cypherIdMap.addLabelToNode(nodeId, nodeLabel);
    }

    public RelationshipIds relationshipIds() {
        return this.relationshipIds;
    }
}

