/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import java.util.Collection;
import java.util.Set;
import java.util.function.LongPredicate;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.NodeMapping;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterator;

public abstract class NodeMappingAdapter
implements NodeMapping {
    private final NodeMapping nodeMapping;

    public NodeMappingAdapter(NodeMapping nodeMapping) {
        this.nodeMapping = nodeMapping;
    }

    public Collection<PrimitiveLongIterable> batchIterables(long batchSize) {
        return this.nodeMapping.batchIterables(batchSize);
    }

    public long toMappedNodeId(long nodeId) {
        return this.nodeMapping.toMappedNodeId(nodeId);
    }

    public long toOriginalNodeId(long nodeId) {
        return this.nodeMapping.toOriginalNodeId(nodeId);
    }

    public long toRootNodeId(long nodeId) {
        return this.nodeMapping.toRootNodeId(nodeId);
    }

    public NodeMapping rootNodeMapping() {
        return this.nodeMapping.rootNodeMapping();
    }

    public boolean contains(long nodeId) {
        return this.nodeMapping.contains(nodeId);
    }

    public long nodeCount() {
        return this.nodeMapping.nodeCount();
    }

    public long rootNodeCount() {
        return this.nodeMapping.rootNodeCount();
    }

    public long highestNeoId() {
        return this.nodeMapping.highestNeoId();
    }

    public void forEachNode(LongPredicate consumer) {
        this.nodeMapping.forEachNode(consumer);
    }

    public PrimitiveLongIterator nodeIterator() {
        return this.nodeMapping.nodeIterator();
    }

    public Set<NodeLabel> nodeLabels(long nodeId) {
        return this.nodeMapping.nodeLabels(nodeId);
    }

    public void forEachNodeLabel(long nodeId, NodeMapping.NodeLabelConsumer consumer) {
        this.nodeMapping.forEachNodeLabel(nodeId, consumer);
    }

    public Set<NodeLabel> availableNodeLabels() {
        return this.nodeMapping.availableNodeLabels();
    }

    public boolean hasLabel(long nodeId, NodeLabel label) {
        return this.nodeMapping.hasLabel(nodeId, label);
    }
}

