/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.RelationshipCursor;
import org.neo4j.gds.core.cypher.CypherRelationshipCursor;

@Generated(from="CypherRelationshipCursor", generator="Immutables")
public final class ImmutableCypherRelationshipCursor
implements CypherRelationshipCursor {
    private final long sourceId;
    private final long targetId;
    private final double property;
    private final long id;
    private final RelationshipType relationshipType;

    private ImmutableCypherRelationshipCursor(long sourceId, long targetId, double property, long id, RelationshipType relationshipType) {
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.property = property;
        this.id = id;
        this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
    }

    private ImmutableCypherRelationshipCursor(ImmutableCypherRelationshipCursor original, long sourceId, long targetId, double property, long id, RelationshipType relationshipType) {
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.property = property;
        this.id = id;
        this.relationshipType = relationshipType;
    }

    public long sourceId() {
        return this.sourceId;
    }

    public long targetId() {
        return this.targetId;
    }

    public double property() {
        return this.property;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public RelationshipType relationshipType() {
        return this.relationshipType;
    }

    public final ImmutableCypherRelationshipCursor withSourceId(long value) {
        if (this.sourceId == value) {
            return this;
        }
        return new ImmutableCypherRelationshipCursor(this, value, this.targetId, this.property, this.id, this.relationshipType);
    }

    public final ImmutableCypherRelationshipCursor withTargetId(long value) {
        if (this.targetId == value) {
            return this;
        }
        return new ImmutableCypherRelationshipCursor(this, this.sourceId, value, this.property, this.id, this.relationshipType);
    }

    public final ImmutableCypherRelationshipCursor withProperty(double value) {
        if (Double.doubleToLongBits(this.property) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableCypherRelationshipCursor(this, this.sourceId, this.targetId, value, this.id, this.relationshipType);
    }

    public final ImmutableCypherRelationshipCursor withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableCypherRelationshipCursor(this, this.sourceId, this.targetId, this.property, value, this.relationshipType);
    }

    public final ImmutableCypherRelationshipCursor withRelationshipType(RelationshipType value) {
        if (this.relationshipType == value) {
            return this;
        }
        RelationshipType newValue = Objects.requireNonNull(value, "relationshipType");
        return new ImmutableCypherRelationshipCursor(this, this.sourceId, this.targetId, this.property, this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCypherRelationshipCursor && this.equalTo((ImmutableCypherRelationshipCursor)another);
    }

    private boolean equalTo(ImmutableCypherRelationshipCursor another) {
        return this.sourceId == another.sourceId && this.targetId == another.targetId && Double.doubleToLongBits(this.property) == Double.doubleToLongBits(another.property) && this.id == another.id && this.relationshipType.equals((Object)another.relationshipType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.sourceId);
        h += (h << 5) + Long.hashCode(this.targetId);
        h += (h << 5) + Double.hashCode(this.property);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.relationshipType.hashCode();
        return h;
    }

    public String toString() {
        return "CypherRelationshipCursor{sourceId=" + this.sourceId + ", targetId=" + this.targetId + ", property=" + this.property + ", id=" + this.id + ", relationshipType=" + this.relationshipType + "}";
    }

    public static CypherRelationshipCursor of(long sourceId, long targetId, double property, long id, RelationshipType relationshipType) {
        return new ImmutableCypherRelationshipCursor(sourceId, targetId, property, id, relationshipType);
    }

    public static CypherRelationshipCursor copyOf(CypherRelationshipCursor instance) {
        if (instance instanceof ImmutableCypherRelationshipCursor) {
            return (ImmutableCypherRelationshipCursor)instance;
        }
        return ImmutableCypherRelationshipCursor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CypherRelationshipCursor", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_ID = 1L;
        private static final long INIT_BIT_TARGET_ID = 2L;
        private static final long INIT_BIT_PROPERTY = 4L;
        private static final long INIT_BIT_ID = 8L;
        private static final long INIT_BIT_RELATIONSHIP_TYPE = 16L;
        private long initBits = 31L;
        private long sourceId;
        private long targetId;
        private double property;
        private long id;
        private RelationshipType relationshipType;

        private Builder() {
        }

        public final Builder from(RelationshipCursor instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CypherRelationshipCursor instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RelationshipCursor instance;
            if (object instanceof RelationshipCursor) {
                instance = (RelationshipCursor)object;
                this.sourceId(instance.sourceId());
                this.targetId(instance.targetId());
                this.property(instance.property());
            }
            if (object instanceof CypherRelationshipCursor) {
                instance = (CypherRelationshipCursor)object;
                this.relationshipType(instance.relationshipType());
                this.id(instance.id());
            }
        }

        public final Builder sourceId(long sourceId) {
            this.sourceId = sourceId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder targetId(long targetId) {
            this.targetId = targetId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder property(double property) {
            this.property = property;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder relationshipType(RelationshipType relationshipType) {
            this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.sourceId = 0L;
            this.targetId = 0L;
            this.property = 0.0;
            this.id = 0L;
            this.relationshipType = null;
            return this;
        }

        public CypherRelationshipCursor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCypherRelationshipCursor(null, this.sourceId, this.targetId, this.property, this.id, this.relationshipType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("property");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("relationshipType");
            }
            return "Cannot build CypherRelationshipCursor, some of required attributes are not set " + attributes;
        }
    }
}

