/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.NodeMapping;
import org.neo4j.gds.core.cypher.CypherNodeMapping;
import org.neo4j.gds.core.cypher.GraphStoreAdapter;
import org.neo4j.gds.core.cypher.NodeLabelUpdater;
import org.neo4j.gds.core.cypher.RelationshipIds;
import org.neo4j.token.TokenHolders;

public class CypherGraphStore
extends GraphStoreAdapter
implements NodeLabelUpdater {
    private final CypherNodeMapping cypherNodeMapping = new CypherNodeMapping(super.nodes());
    private RelationshipIds relationshipIds;

    public CypherGraphStore(GraphStore graphStore) {
        super(graphStore);
    }

    public void initialize(TokenHolders tokenHolders) {
        this.relationshipIds = RelationshipIds.fromGraphStore(this.innerGraphStore(), tokenHolders);
    }

    @Override
    public NodeMapping nodes() {
        return this.cypherNodeMapping;
    }

    @Override
    public void addNodeLabel(NodeLabel nodeLabel) {
        this.cypherNodeMapping.addNodeLabel(nodeLabel);
    }

    @Override
    public void addLabelToNode(long nodeId, NodeLabel nodeLabel) {
        this.cypherNodeMapping.addLabelToNode(nodeId, nodeLabel);
    }

    public RelationshipIds relationshipIds() {
        return this.relationshipIds;
    }
}

