/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.RelationshipCursor;
import org.neo4j.gds.core.cypher.CypherRelationshipCursor;
import org.neo4j.gds.core.cypher.RelationshipIds;

public class RelationshipWithIdCursorIterator
implements Iterator<CypherRelationshipCursor> {
    private final List<RelationshipIds.RelationshipIdContext> relationshipIdContexts;
    private final long nodeId;
    private final Predicate<RelationshipType> relationshipTypePredicate;
    private long relTypeOffset;
    private long relationshipId;
    private int contextCounter;
    private Iterator<RelationshipCursor> currentRelCursor;
    private RelationshipIds.RelationshipIdContext currentRelContext;

    RelationshipWithIdCursorIterator(List<RelationshipIds.RelationshipIdContext> relationshipIdContexts, long nodeId, Predicate<RelationshipType> relationshipTypePredicate) {
        this.relationshipIdContexts = relationshipIdContexts;
        this.nodeId = nodeId;
        this.relationshipTypePredicate = relationshipTypePredicate;
        this.relTypeOffset = -1L;
        this.contextCounter = -1;
    }

    @Override
    public boolean hasNext() {
        if (this.currentRelCursor == null) {
            if (this.contextCounter == this.relationshipIdContexts.size() - 1) {
                return false;
            }
            this.progressToNextContext();
        }
        if (!this.relationshipTypePredicate.test(this.currentRelContext.relationshipType()) || !this.currentRelCursor.hasNext()) {
            this.currentRelCursor = null;
            return this.hasNext();
        }
        return true;
    }

    @Override
    public CypherRelationshipCursor next() {
        RelationshipCursor relationshipCursor = this.currentRelCursor.next();
        return CypherRelationshipCursor.fromRelationshipCursor(relationshipCursor, this.relationshipId++, this.currentRelContext.relationshipType());
    }

    private void progressToNextContext() {
        this.relTypeOffset = this.relTypeOffset == -1L ? 0L : (this.relTypeOffset += this.currentRelContext.relationshipCount());
        ++this.contextCounter;
        this.currentRelContext = this.relationshipIdContexts.get(this.contextCounter);
        this.currentRelCursor = this.currentRelContext.graph().streamRelationships(this.nodeId, Double.NaN).iterator();
        this.relationshipId = this.relTypeOffset + this.currentRelContext.offsets().get(this.nodeId);
    }
}

