/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.cypher;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.cypher.RelationshipIds;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

@Generated(from="RelationshipIds.RelationshipIdContext", generator="Immutables")
public final class ImmutableRelationshipIdContext
implements RelationshipIds.RelationshipIdContext {
    private final RelationshipType relationshipType;
    private final long relationshipCount;
    private final Graph graph;
    private final HugeLongArray offsets;

    private ImmutableRelationshipIdContext(RelationshipType relationshipType, long relationshipCount, Graph graph, HugeLongArray offsets) {
        this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
        this.relationshipCount = relationshipCount;
        this.graph = Objects.requireNonNull(graph, "graph");
        this.offsets = Objects.requireNonNull(offsets, "offsets");
    }

    private ImmutableRelationshipIdContext(ImmutableRelationshipIdContext original, RelationshipType relationshipType, long relationshipCount, Graph graph, HugeLongArray offsets) {
        this.relationshipType = relationshipType;
        this.relationshipCount = relationshipCount;
        this.graph = graph;
        this.offsets = offsets;
    }

    @Override
    public RelationshipType relationshipType() {
        return this.relationshipType;
    }

    @Override
    public long relationshipCount() {
        return this.relationshipCount;
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    public HugeLongArray offsets() {
        return this.offsets;
    }

    public final ImmutableRelationshipIdContext withRelationshipType(RelationshipType value) {
        if (this.relationshipType == value) {
            return this;
        }
        RelationshipType newValue = Objects.requireNonNull(value, "relationshipType");
        return new ImmutableRelationshipIdContext(this, newValue, this.relationshipCount, this.graph, this.offsets);
    }

    public final ImmutableRelationshipIdContext withRelationshipCount(long value) {
        if (this.relationshipCount == value) {
            return this;
        }
        return new ImmutableRelationshipIdContext(this, this.relationshipType, value, this.graph, this.offsets);
    }

    public final ImmutableRelationshipIdContext withGraph(Graph value) {
        if (this.graph == value) {
            return this;
        }
        Graph newValue = Objects.requireNonNull(value, "graph");
        return new ImmutableRelationshipIdContext(this, this.relationshipType, this.relationshipCount, newValue, this.offsets);
    }

    public final ImmutableRelationshipIdContext withOffsets(HugeLongArray value) {
        if (this.offsets == value) {
            return this;
        }
        HugeLongArray newValue = Objects.requireNonNull(value, "offsets");
        return new ImmutableRelationshipIdContext(this, this.relationshipType, this.relationshipCount, this.graph, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationshipIdContext && this.equalTo((ImmutableRelationshipIdContext)another);
    }

    private boolean equalTo(ImmutableRelationshipIdContext another) {
        return this.relationshipType.equals((Object)another.relationshipType) && this.relationshipCount == another.relationshipCount && this.graph.equals(another.graph) && this.offsets.equals(another.offsets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relationshipType.hashCode();
        h += (h << 5) + Long.hashCode(this.relationshipCount);
        h += (h << 5) + this.graph.hashCode();
        h += (h << 5) + this.offsets.hashCode();
        return h;
    }

    public String toString() {
        return "RelationshipIdContext{relationshipType=" + this.relationshipType + ", relationshipCount=" + this.relationshipCount + ", graph=" + this.graph + ", offsets=" + this.offsets + "}";
    }

    public static RelationshipIds.RelationshipIdContext of(RelationshipType relationshipType, long relationshipCount, Graph graph, HugeLongArray offsets) {
        return new ImmutableRelationshipIdContext(relationshipType, relationshipCount, graph, offsets);
    }

    public static RelationshipIds.RelationshipIdContext copyOf(RelationshipIds.RelationshipIdContext instance) {
        if (instance instanceof ImmutableRelationshipIdContext) {
            return (ImmutableRelationshipIdContext)instance;
        }
        return ImmutableRelationshipIdContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RelationshipIds.RelationshipIdContext", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_RELATIONSHIP_TYPE = 1L;
        private static final long INIT_BIT_RELATIONSHIP_COUNT = 2L;
        private static final long INIT_BIT_GRAPH = 4L;
        private static final long INIT_BIT_OFFSETS = 8L;
        private long initBits = 15L;
        private RelationshipType relationshipType;
        private long relationshipCount;
        private Graph graph;
        private HugeLongArray offsets;

        private Builder() {
        }

        public final Builder from(RelationshipIds.RelationshipIdContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.relationshipType(instance.relationshipType());
            this.relationshipCount(instance.relationshipCount());
            this.graph(instance.graph());
            this.offsets(instance.offsets());
            return this;
        }

        public final Builder relationshipType(RelationshipType relationshipType) {
            this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipCount(long relationshipCount) {
            this.relationshipCount = relationshipCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder graph(Graph graph) {
            this.graph = Objects.requireNonNull(graph, "graph");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder offsets(HugeLongArray offsets) {
            this.offsets = Objects.requireNonNull(offsets, "offsets");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.relationshipType = null;
            this.relationshipCount = 0L;
            this.graph = null;
            this.offsets = null;
            return this;
        }

        public RelationshipIds.RelationshipIdContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelationshipIdContext(null, this.relationshipType, this.relationshipCount, this.graph, this.offsets);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relationshipType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relationshipCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("graph");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("offsets");
            }
            return "Cannot build RelationshipIdContext, some of required attributes are not set " + attributes;
        }
    }
}

