/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.projection;

import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.ImmutableIdMapAndProperties;
import org.neo4j.gds.core.loading.construction.NodeLabelToken;
import org.neo4j.gds.core.loading.construction.NodeLabelTokens;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.utils.paged.ShardedLongLongMap;
import org.neo4j.gds.projection.HighLimitIdMap;
import org.neo4j.values.storable.Value;

final class LazyIdMapBuilder
implements PartialIdMap {
    private final AtomicBoolean isEmpty = new AtomicBoolean(true);
    private final ShardedLongLongMap.Builder intermediateIdMapBuilder = ShardedLongLongMap.builder((int)4);
    private final NodesBuilder nodesBuilder;

    LazyIdMapBuilder(boolean hasLabelInformation, boolean hasProperties) {
        this.nodesBuilder = GraphFactory.initNodesBuilder().maxOriginalId(-1L).hasLabelInformation(hasLabelInformation).hasProperties(hasProperties).deduplicateIds(false).build();
    }

    long addNode(long nodeId, @Nullable NodeLabelToken nodeLabels) {
        long intermediateId = this.intermediateIdMapBuilder.toMappedNodeId(nodeId);
        if (intermediateId != -1L) {
            return intermediateId;
        }
        intermediateId = this.intermediateIdMapBuilder.addNode(nodeId);
        this.isEmpty.lazySet(false);
        if (nodeLabels == null) {
            nodeLabels = NodeLabelTokens.empty();
        }
        this.nodesBuilder.addNode(intermediateId, nodeLabels);
        return intermediateId;
    }

    long addNodeWithProperties(long nodeId, Map<String, Value> properties, @Nullable NodeLabelToken nodeLabels) {
        long intermediateId = this.intermediateIdMapBuilder.toMappedNodeId(nodeId);
        if (intermediateId != -1L) {
            return intermediateId;
        }
        intermediateId = this.intermediateIdMapBuilder.addNode(nodeId);
        this.isEmpty.lazySet(false);
        if (nodeLabels == null) {
            nodeLabels = NodeLabelTokens.empty();
        }
        if (properties.isEmpty()) {
            this.nodesBuilder.addNode(intermediateId, nodeLabels);
        } else {
            this.nodesBuilder.addNode(intermediateId, properties, nodeLabels);
        }
        return intermediateId;
    }

    public long toMappedNodeId(long nodeId) {
        return nodeId;
    }

    public OptionalLong rootNodeCount() {
        return this.isEmpty.getAcquire() ? OptionalLong.empty() : OptionalLong.of(this.nodesBuilder.importedNodes());
    }

    NodesBuilder.IdMapAndProperties build() {
        NodesBuilder.IdMapAndProperties idMapAndProperties = this.nodesBuilder.build();
        ShardedLongLongMap intermediateIdMap = this.intermediateIdMapBuilder.build();
        IdMap internalIdMap = idMapAndProperties.idMap();
        HighLimitIdMap idMap = new HighLimitIdMap(intermediateIdMap, internalIdMap);
        return ImmutableIdMapAndProperties.builder().idMap((IdMap)idMap).nodeProperties(idMapAndProperties.nodeProperties()).build();
    }
}

