/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.projection;

import java.util.Collection;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.IdMapAdapter;
import org.neo4j.gds.core.utils.paged.ShardedLongLongMap;

final class HighLimitIdMap
extends IdMapAdapter {
    private final ShardedLongLongMap highToLowIdSpace;

    HighLimitIdMap(ShardedLongLongMap intermediateIdMap, IdMap internalIdMap) {
        super(internalIdMap);
        this.highToLowIdSpace = intermediateIdMap;
    }

    public long toOriginalNodeId(long nodeId) {
        return this.highToLowIdSpace.toOriginalNodeId(super.toOriginalNodeId(nodeId));
    }

    public long toMappedNodeId(long nodeId) {
        return super.toMappedNodeId(this.highToLowIdSpace.toMappedNodeId(nodeId));
    }

    public long toRootNodeId(long nodeId) {
        return this.highToLowIdSpace.toOriginalNodeId(super.toRootNodeId(nodeId));
    }

    public boolean contains(long nodeId) {
        return super.contains(this.highToLowIdSpace.toMappedNodeId(nodeId));
    }

    public long highestNeoId() {
        return this.highToLowIdSpace.maxOriginalId();
    }

    public IdMap withFilteredLabels(Collection<NodeLabel> nodeLabels, int concurrency) {
        IdMap filteredInternalIdMap = super.withFilteredLabels(nodeLabels, concurrency);
        return new HighLimitIdMap(this.highToLowIdSpace, filteredInternalIdMap);
    }
}

