/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.projection;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.projection.CypherAggregation;

public final class GraphProjectFromCypherAggregationConfigImpl
implements CypherAggregation.GraphProjectFromCypherAggregationConfig {
    private String username;
    private String graphName;
    private int readConcurrency;
    private long nodeCount;
    private long relationshipCount;
    private ZonedDateTime creationTime;
    private boolean validateRelationships;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private JobId jobId;

    public GraphProjectFromCypherAggregationConfigImpl(@NotNull String username, @NotNull String graphName, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = GraphProjectConfig.validateName((String)((String)CypherMapWrapper.failOnNull((String)"graphName", (Object)graphName)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.readConcurrency = config.getInt("readConcurrency", CypherAggregation.GraphProjectFromCypherAggregationConfig.super.readConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeCount = config.getLong("nodeCount", CypherAggregation.GraphProjectFromCypherAggregationConfig.super.nodeCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipCount = config.getLong("relationshipCount", CypherAggregation.GraphProjectFromCypherAggregationConfig.super.relationshipCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.creationTime = (ZonedDateTime)CypherMapWrapper.failOnNull((String)"creationTime", (Object)((ZonedDateTime)config.getChecked("creationTime", (Object)CypherAggregation.GraphProjectFromCypherAggregationConfig.super.creationTime(), ZonedDateTime.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateRelationships = config.getBool("validateRelationships", CypherAggregation.GraphProjectFromCypherAggregationConfig.super.validateRelationships());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", CypherAggregation.GraphProjectFromCypherAggregationConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", CypherAggregation.GraphProjectFromCypherAggregationConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapWrapper.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)CypherAggregation.GraphProjectFromCypherAggregationConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateReadConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    public String username() {
        return this.username;
    }

    public String graphName() {
        return this.graphName;
    }

    public int readConcurrency() {
        return this.readConcurrency;
    }

    public long nodeCount() {
        return this.nodeCount;
    }

    public long relationshipCount() {
        return this.relationshipCount;
    }

    public ZonedDateTime creationTime() {
        return this.creationTime;
    }

    public boolean validateRelationships() {
        return this.validateRelationships;
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("readConcurrency", "nodeCount", "relationshipCount", "creationTime", "validateRelationships", "username", "sudo", "jobId");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("readConcurrency", this.readConcurrency());
        map.put("nodeCount", this.nodeCount());
        map.put("relationshipCount", this.relationshipCount());
        map.put("creationTime", this.creationTime());
        map.put("validateRelationships", this.validateRelationships());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        return map;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String username;
        @NotNull
        private String graphName;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public Builder readConcurrency(int readConcurrency) {
            this.config.put("readConcurrency", readConcurrency);
            return this;
        }

        public Builder nodeCount(long nodeCount) {
            this.config.put("nodeCount", nodeCount);
            return this;
        }

        public Builder relationshipCount(long relationshipCount) {
            this.config.put("relationshipCount", relationshipCount);
            return this;
        }

        public Builder creationTime(ZonedDateTime creationTime) {
            this.config.put("creationTime", creationTime);
            return this;
        }

        public Builder validateRelationships(boolean validateRelationships) {
            this.config.put("validateRelationships", validateRelationships);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public CypherAggregation.GraphProjectFromCypherAggregationConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GraphProjectFromCypherAggregationConfigImpl(this.username, this.graphName, config);
        }
    }
}

