/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.projection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Value;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ReturnType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.RelationshipPropertyStore;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.ImmutableGraphSchema;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.api.schema.RelationshipSchema;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.compress.AdjacencyCompressor;
import org.neo4j.gds.core.loading.CSRGraphStore;
import org.neo4j.gds.core.loading.CSRGraphStoreUtil;
import org.neo4j.gds.core.loading.Capabilities;
import org.neo4j.gds.core.loading.GraphStoreBuilder;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.loading.ImmutableStaticCapabilities;
import org.neo4j.gds.core.loading.ReadHelper;
import org.neo4j.gds.core.loading.ValueConverter;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.NodeLabelToken;
import org.neo4j.gds.core.loading.construction.NodeLabelTokens;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilderBuilder;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.projection.AggregationResultImpl;
import org.neo4j.gds.projection.GraphProjectFromCypherAggregationConfigImpl;
import org.neo4j.gds.projection.LazyIdMapBuilder;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public final class CypherAggregation
extends BaseProc {
    @UserAggregationFunction(name="gds.alpha.graph.project")
    @Description(value="Creates a named graph in the catalog for use by algorithms.")
    public GraphAggregator projectFromCypherAggregation() {
        ProgressTimer progressTimer = ProgressTimer.start();
        return new GraphAggregator(progressTimer, this.api.databaseId(), this.username());
    }

    @Configuration
    public static interface AggregationResult {
        @ReturnType.Include
        public String graphName();

        @ReturnType.Include
        public long nodeCount();

        @ReturnType.Include
        public long relationshipCount();

        @ReturnType.Include
        public long projectMillis();

        @Configuration.ToMap
        public Map<String, Object> toMap();
    }

    @ValueClass
    @Configuration
    public static interface GraphProjectFromCypherAggregationConfig
    extends GraphProjectConfig {
        @Value.Default
        @Configuration.Ignore
        default public Orientation orientation() {
            return Orientation.NATURAL;
        }

        @Value.Default
        @Configuration.Ignore
        default public Aggregation aggregation() {
            return Aggregation.NONE;
        }

        @Configuration.Ignore
        default public GraphStoreFactory.Supplier graphStoreFactory() {
            throw new UnsupportedOperationException("Cypher aggregation does not work over the default graph store framework");
        }

        @Value.Derived
        @Configuration.Ignore
        default public Set<String> outputFieldDenylist() {
            return Set.of("nodeCount", "relationshipCount", "readConcurrency", "sudo", "validateRelationships");
        }

        public static GraphProjectFromCypherAggregationConfig of(String userName, String graphName) {
            return new GraphProjectFromCypherAggregationConfigImpl(userName, graphName, CypherMapWrapper.empty());
        }

        @Configuration.Ignore
        default public <R> R accept(GraphProjectConfig.Cases<R> cases) {
            if (cases instanceof Cases) {
                return ((Cases)cases).cypherAggregation(this);
            }
            return null;
        }

        public static interface Visitor
        extends Cases<Void> {
            @Override
            default public Void cypherAggregation(GraphProjectFromCypherAggregationConfig cypherAggregationConfig) {
                this.visit(cypherAggregationConfig);
                return null;
            }

            default public void visit(GraphProjectFromCypherAggregationConfig cypherAggregationConfig) {
            }
        }

        public static interface Cases<R>
        extends GraphProjectConfig.Cases<R> {
            public R cypherAggregation(GraphProjectFromCypherAggregationConfig var1);
        }
    }

    public static class GraphAggregator {
        private final ProgressTimer progressTimer;
        private final NamedDatabaseId databaseId;
        private final ImmutableGraphSchema.Builder graphSchemaBuilder;
        private final String username;
        @Nullable
        private AggregationResult result;
        @Nullable
        private String graphName;
        @Nullable
        private LazyIdMapBuilder idMapBuilder;
        @Nullable
        private List<RelationshipPropertySchema> relationshipPropertySchemas;
        private final Map<RelationshipType, RelationshipsBuilder> relImporters;

        GraphAggregator(ProgressTimer progressTimer, NamedDatabaseId databaseId, String username) {
            this.progressTimer = progressTimer;
            this.databaseId = databaseId;
            this.username = username;
            this.relImporters = new HashMap<RelationshipType, RelationshipsBuilder>();
            this.graphSchemaBuilder = ImmutableGraphSchema.builder();
        }

        @UserAggregationUpdate
        public void update(@Name(value="graphName") String graphName, @Name(value="sourceNode") Object sourceNode, @Name(value="targetNode", defaultValue="null") @Nullable Object targetNode, @Name(value="nodesConfig", defaultValue="null") @Nullable Map<String, Object> nodesConfig, @Name(value="relationshipConfig", defaultValue="null") @Nullable Map<String, Object> relationshipConfig) {
            if (this.graphName == null) {
                this.validateGraphName(graphName);
                this.graphName = graphName;
            }
            Map<String, Value> sourceNodePropertyValues = null;
            Map<String, Value> targetNodePropertyValues = null;
            NodeLabelToken sourceNodeLabels = null;
            NodeLabelToken targetNodeLabels = null;
            if (nodesConfig != null) {
                sourceNodePropertyValues = this.propertiesConfig("sourceNodeProperties", nodesConfig);
                sourceNodeLabels = this.labelsConfig(sourceNode, "sourceNodeLabels", nodesConfig);
                if (targetNode != null) {
                    targetNodePropertyValues = this.propertiesConfig("targetNodeProperties", nodesConfig);
                    targetNodeLabels = this.labelsConfig(targetNode, "targetNodeLabels", nodesConfig);
                }
                if (!nodesConfig.isEmpty()) {
                    CypherMapWrapper.create(nodesConfig).requireOnlyKeysFrom(List.of("sourceNodeProperties", "sourceNodeLabels", "targetNodeProperties", "targetNodeLabels"));
                }
            }
            if (this.idMapBuilder == null) {
                this.idMapBuilder = this.newIdMapBuilder(sourceNodeLabels, sourceNodePropertyValues, targetNodeLabels, targetNodePropertyValues);
            }
            Map<String, Value> relationshipProperties = null;
            RelationshipType relationshipType = null;
            if (relationshipConfig != null) {
                if (this.relationshipPropertySchemas == null) {
                    this.relationshipPropertySchemas = new ArrayList<RelationshipPropertySchema>();
                    Object relationshipPropertyKeys = relationshipConfig.get("properties");
                    if (relationshipPropertyKeys instanceof Map) {
                        for (Object propertyKey : ((Map)relationshipPropertyKeys).keySet()) {
                            this.relationshipPropertySchemas.add(RelationshipPropertySchema.of((String)String.valueOf(propertyKey), (ValueType)ValueType.DOUBLE));
                        }
                    }
                }
                relationshipProperties = this.propertiesConfig("properties", relationshipConfig);
                relationshipType = this.typeConfig("relationshipType", relationshipConfig);
                if (!relationshipConfig.isEmpty()) {
                    CypherMapWrapper.create(relationshipConfig).requireOnlyKeysFrom(List.of("properties", "relationshipType"));
                }
            }
            RelationshipsBuilder relImporter = this.relImporters.computeIfAbsent(relationshipType, type -> this.newRelImporter());
            long intermediateSourceId = this.loadNode(sourceNode, sourceNodeLabels, sourceNodePropertyValues);
            if (targetNode != null) {
                long intermediateTargetId = this.loadNode(targetNode, targetNodeLabels, targetNodePropertyValues);
                if (this.relationshipPropertySchemas != null && !this.relationshipPropertySchemas.isEmpty()) {
                    assert (relationshipProperties != null);
                    if (this.relationshipPropertySchemas.size() == 1) {
                        String relationshipProperty = this.relationshipPropertySchemas.get(0).key();
                        double propertyValue = GraphAggregator.loadOneRelationshipProperty(relationshipProperties, relationshipProperty);
                        relImporter.addFromInternal(intermediateSourceId, intermediateTargetId, propertyValue);
                    } else {
                        double[] propertyValues = GraphAggregator.loadMultipleRelationshipProperties(relationshipProperties, this.relationshipPropertySchemas);
                        relImporter.addFromInternal(intermediateSourceId, intermediateTargetId, propertyValues);
                    }
                } else {
                    relImporter.addFromInternal(intermediateSourceId, intermediateTargetId);
                }
            }
        }

        @NotNull
        private LazyIdMapBuilder newIdMapBuilder(@Nullable NodeLabelToken sourceNodeLabels, @Nullable Map<String, Value> sourceNodeProperties, @Nullable NodeLabelToken targetNodeLabels, @Nullable Map<String, Value> targetNodeProperties) {
            boolean hasLabelInformation = sourceNodeLabels != null || targetNodeLabels != null;
            boolean hasProperties = sourceNodeProperties != null || targetNodeProperties != null;
            return new LazyIdMapBuilder(hasLabelInformation, hasProperties);
        }

        private void validateGraphName(String graphName) {
            if (GraphStoreCatalog.exists((String)this.username, (NamedDatabaseId)this.databaseId, (String)graphName)) {
                throw new IllegalArgumentException("Graph " + graphName + " already exists");
            }
        }

        @Nullable
        private Map<String, Value> propertiesConfig(String propertyKey, @NotNull Map<String, Object> propertiesConfig) {
            Object nodeProperties = propertiesConfig.remove(propertyKey);
            if (nodeProperties == null || nodeProperties instanceof Map) {
                return GraphAggregator.objectsToValues((Map)nodeProperties);
            }
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The value of `%s` must be a `Map of Property Values`, but was `%s`.", (Object[])new Object[]{propertyKey, nodeProperties.getClass().getSimpleName()}));
        }

        @Nullable
        private NodeLabelToken labelsConfig(Object node, String nodeLabelKey, @NotNull Map<String, Object> nodesConfig) {
            Object nodeLabelsEntry = nodesConfig.remove(nodeLabelKey);
            return this.tryLabelsConfig(node, nodeLabelsEntry, nodeLabelKey);
        }

        @Contract(value="_, null, _ -> null")
        @Nullable
        private NodeLabelToken tryLabelsConfig(Object node, @Nullable Object nodeLabels, String nodeLabelKey) {
            if (nodeLabels == null || Boolean.FALSE.equals(nodeLabels)) {
                return null;
            }
            if (Boolean.TRUE.equals(nodeLabels)) {
                if (node instanceof Node) {
                    return NodeLabelTokens.ofNullable((Object)((Node)node).getLabels());
                }
                throw new IllegalArgumentException("Using `true` to load all labels does only work if the node is a Neo4j node object");
            }
            NodeLabelToken nodeLabelToken = NodeLabelTokens.ofNullable((Object)nodeLabels);
            if (nodeLabelToken == null) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The value of `%s` must be either a `List of Strings`, a `String`, or a `Boolean`, but was `%s`.", (Object[])new Object[]{nodeLabelKey, nodeLabels.getClass().getSimpleName()}));
            }
            return nodeLabelToken;
        }

        @Nullable
        private RelationshipType typeConfig(String relationshipTypeKey, @NotNull Map<String, Object> relationshipConfig) {
            Object relationshipTypeEntry = relationshipConfig.remove(relationshipTypeKey);
            if (relationshipTypeEntry instanceof String) {
                return RelationshipType.of((String)((String)relationshipTypeEntry));
            }
            if (relationshipTypeEntry == null) {
                return null;
            }
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The value of `%s` must be `String`, but was `%s`.", (Object[])new Object[]{relationshipTypeKey, relationshipTypeEntry.getClass().getSimpleName()}));
        }

        private RelationshipsBuilder newRelImporter() {
            assert (this.idMapBuilder != null);
            RelationshipsBuilderBuilder relationshipsBuilderBuilder = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)this.idMapBuilder).orientation(Orientation.NATURAL).aggregation(Aggregation.NONE).concurrency(4);
            if (this.relationshipPropertySchemas != null) {
                for (RelationshipPropertySchema ignored : this.relationshipPropertySchemas) {
                    relationshipsBuilderBuilder.addPropertyConfig(Aggregation.NONE, DefaultValue.forDouble());
                }
            }
            return relationshipsBuilderBuilder.build();
        }

        @Nullable
        private static Map<String, Value> objectsToValues(@Nullable Map<String, Object> properties) {
            if (properties == null) {
                return null;
            }
            HashMap<String, Value> values = new HashMap<String, Value>(properties.size());
            properties.forEach((key, valueObject) -> {
                if (valueObject != null) {
                    Value value = ValueConverter.toValue((Object)valueObject);
                    values.put((String)key, value);
                }
            });
            return values;
        }

        private long extractNodeId(@Nullable Object node) {
            if (node instanceof Node) {
                return ((Node)node).getId();
            }
            if (node instanceof Long) {
                return (Long)node;
            }
            if (node instanceof Integer) {
                return ((Integer)node).intValue();
            }
            throw this.invalidNodeType(node);
        }

        private IllegalArgumentException invalidNodeType(@Nullable Object node) {
            Object nodeType = node instanceof String ? "STRING" : (node instanceof Number ? "FLOAT" : (node instanceof Boolean ? "BOOLEAN" : (node instanceof Relationship ? "RELATIONSHIP" : (node instanceof Path ? "PATH" : (node instanceof Map ? "MAP" : (node instanceof List ? "LIST" : (node == null ? "NULL" : "UNKNOWN: " + node.getClass().getName())))))));
            return new IllegalArgumentException("The node has to be either a NODE or an INTEGER, but got " + (String)nodeType);
        }

        private long loadNode(@Nullable Object node, @Nullable NodeLabelToken nodeLabels, @Nullable Map<String, Value> nodeProperties) {
            assert (this.idMapBuilder != null);
            long originalNodeId = this.extractNodeId(node);
            return nodeProperties == null ? this.idMapBuilder.addNode(originalNodeId, nodeLabels) : this.idMapBuilder.addNodeWithProperties(originalNodeId, nodeProperties, nodeLabels);
        }

        private static double loadOneRelationshipProperty(@NotNull Map<String, Value> relationshipProperties, String relationshipPropertyKey) {
            Value propertyValueObject = relationshipProperties.get(relationshipPropertyKey);
            Value propertyValue = Objects.requireNonNullElse(propertyValueObject, Values.NO_VALUE);
            return ReadHelper.extractValue((Value)propertyValue, (double)Double.NaN);
        }

        private static double[] loadMultipleRelationshipProperties(@NotNull Map<String, Value> relationshipProperties, List<RelationshipPropertySchema> relationshipPropertyKeys) {
            double[] propertyValues = new double[relationshipPropertyKeys.size()];
            Arrays.setAll(propertyValues, i -> {
                String relationshipPropertyKey = ((RelationshipPropertySchema)relationshipPropertyKeys.get(i)).key();
                return GraphAggregator.loadOneRelationshipProperty(relationshipProperties, relationshipPropertyKey);
            });
            return propertyValues;
        }

        @UserAggregationResult
        @ReturnType(value=AggregationResult.class)
        @Nullable
        public Map<String, Object> result() {
            AggregationResult result = this.buildGraph();
            return result == null ? null : result.toMap();
        }

        @Nullable
        public AggregationResult buildGraph() {
            String graphName = this.graphName;
            if (graphName == null) {
                return null;
            }
            if (this.result != null) {
                return this.result;
            }
            this.validateGraphName(graphName);
            GraphStoreBuilder graphStoreBuilder = new GraphStoreBuilder().concurrency(4).capabilities((Capabilities)ImmutableStaticCapabilities.of((boolean)true)).databaseId(this.databaseId);
            AdjacencyCompressor.ValueMapper valueMapper = this.buildNodesWithProperties(graphStoreBuilder);
            this.buildRelationshipsWithProperties(graphStoreBuilder, valueMapper);
            CSRGraphStore graphStore = graphStoreBuilder.schema(this.graphSchemaBuilder.build()).build();
            GraphProjectFromCypherAggregationConfig config = GraphProjectFromCypherAggregationConfig.of(this.username, graphName);
            GraphStoreCatalog.set((GraphProjectConfig)config, (GraphStore)graphStore);
            long projectMillis = this.progressTimer.stop().getDuration();
            this.result = AggregationResultImpl.builder().graphName(graphName).nodeCount(graphStore.nodeCount()).relationshipCount(graphStore.relationshipCount()).projectMillis(projectMillis).build();
            return this.result;
        }

        private AdjacencyCompressor.ValueMapper buildNodesWithProperties(GraphStoreBuilder graphStoreBuilder) {
            assert (this.idMapBuilder != null);
            NodesBuilder.IdMapAndProperties idMapAndProperties = this.idMapBuilder.build();
            IdMap nodes = idMapAndProperties.idMap();
            Optional maybeNodeProperties = idMapAndProperties.nodeProperties();
            graphStoreBuilder.nodes(nodes);
            Map nodeSchema = maybeNodeProperties.map(nodeProperties -> GraphAggregator.nodeSchemaWithProperties(nodes.availableNodeLabels(), nodeProperties)).orElseGet(() -> GraphAggregator.nodeSchemaWithoutProperties(nodes.availableNodeLabels())).unionProperties();
            NodeSchema.Builder nodeSchemaBuilder = NodeSchema.builder();
            nodes.availableNodeLabels().forEach(arg_0 -> ((NodeSchema.Builder)nodeSchemaBuilder).addLabel(arg_0));
            nodeSchema.forEach((propertyKey, propertySchema) -> nodes.availableNodeLabels().forEach(label -> nodeSchemaBuilder.addProperty(label, propertySchema.key(), propertySchema)));
            this.graphSchemaBuilder.nodeSchema(nodeSchemaBuilder.build());
            maybeNodeProperties.ifPresent(allNodeProperties -> CSRGraphStoreUtil.extractNodeProperties((GraphStoreBuilder)graphStoreBuilder, nodeSchema::get, (Map)allNodeProperties));
            return arg_0 -> ((IdMap)nodes.rootIdMap()).toMappedNodeId(arg_0);
        }

        private void buildRelationshipsWithProperties(GraphStoreBuilder graphStoreBuilder, AdjacencyCompressor.ValueMapper valueMapper) {
            RelationshipSchema.Builder relationshipSchemaBuilder = RelationshipSchema.builder();
            this.relImporters.forEach((relationshipType, relImporter) -> {
                List allRelationships = relImporter.buildAll(Optional.of(valueMapper), Optional.empty());
                RelationshipPropertyStore propertyStore = CSRGraphStoreUtil.buildRelationshipPropertyStore((List)allRelationships, Objects.requireNonNullElse(this.relationshipPropertySchemas, List.of()));
                RelationshipType relType = relationshipType == null ? RelationshipType.ALL_RELATIONSHIPS : relationshipType;
                propertyStore.relationshipProperties().forEach((propertyKey, relationshipProperties) -> relationshipSchemaBuilder.addProperty(relType, propertyKey, relationshipProperties.propertySchema()));
                graphStoreBuilder.putRelationships(relType, ((Relationships)allRelationships.get(0)).topology());
                graphStoreBuilder.putRelationshipPropertyStores(relType, propertyStore);
            });
            this.graphSchemaBuilder.relationshipSchema(relationshipSchemaBuilder.build());
            this.relImporters.clear();
        }

        private static NodeSchema nodeSchemaWithProperties(Iterable<NodeLabel> nodeLabels, Map<String, NodePropertyValues> propertyMap) {
            NodeSchema.Builder nodeSchemaBuilder = NodeSchema.builder();
            nodeLabels.forEach(nodeLabel -> propertyMap.forEach((propertyName, nodeProperties) -> nodeSchemaBuilder.addProperty(nodeLabel, propertyName, nodeProperties.valueType())));
            return nodeSchemaBuilder.build();
        }

        private static NodeSchema nodeSchemaWithoutProperties(Iterable<NodeLabel> nodeLabels) {
            NodeSchema.Builder nodeSchemaBuilder = NodeSchema.builder();
            nodeLabels.forEach(arg_0 -> ((NodeSchema.Builder)nodeSchemaBuilder).addLabel(arg_0));
            return nodeSchemaBuilder.build();
        }
    }
}

