/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.projection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.projection.CypherAggregation;

public final class AggregationResultImpl
implements CypherAggregation.AggregationResult {
    private String graphName;
    private long nodeCount;
    private long relationshipCount;
    private long projectMillis;

    public AggregationResultImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.graphName = (String)CypherMapWrapper.failOnNull((String)"graphName", (Object)config.requireString("graphName"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeCount = config.requireLong("nodeCount");
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipCount = config.requireLong("relationshipCount");
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.projectMillis = config.requireLong("projectMillis");
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public long nodeCount() {
        return this.nodeCount;
    }

    @Override
    public long relationshipCount() {
        return this.relationshipCount;
    }

    @Override
    public long projectMillis() {
        return this.projectMillis;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("graphName", this.graphName());
        map.put("nodeCount", this.nodeCount());
        map.put("relationshipCount", this.relationshipCount());
        map.put("projectMillis", this.projectMillis());
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder graphName(String graphName) {
            this.config.put("graphName", graphName);
            return this;
        }

        public Builder nodeCount(long nodeCount) {
            this.config.put("nodeCount", nodeCount);
            return this;
        }

        public Builder relationshipCount(long relationshipCount) {
            this.config.put("relationshipCount", relationshipCount);
            return this;
        }

        public Builder projectMillis(long projectMillis) {
            this.config.put("projectMillis", projectMillis);
            return this;
        }

        public CypherAggregation.AggregationResult build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new AggregationResultImpl(config);
        }
    }
}

