/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.utils;

import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.ExceptionUtil;
import org.neo4j.kernel.api.KernelTransaction;

public abstract class StatementApi {
    protected final TransactionContext tx;

    protected StatementApi(TransactionContext tx) {
        this.tx = tx;
    }

    protected final <T> T applyInTransaction(TxFunction<T> fun) {
        try {
            return (T)this.tx.apply((tx, ktx) -> fun.apply(ktx));
        }
        catch (Exception e) {
            ExceptionUtil.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    protected final void acceptInTransaction(TxConsumer fun) {
        try {
            this.tx.accept((tx, ktx) -> fun.accept(ktx));
        }
        catch (Exception e) {
            ExceptionUtil.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    protected final int getOrCreatePropertyToken(String propertyKey) {
        return this.applyInTransaction(stmt -> stmt.tokenWrite().propertyKeyGetOrCreateForName(propertyKey));
    }

    protected final int getOrCreateRelationshipToken(String relationshipType) {
        return this.applyInTransaction(stmt -> stmt.tokenWrite().relationshipTypeGetOrCreateForName(relationshipType));
    }

    public static interface TxFunction<T> {
        public T apply(KernelTransaction var1) throws Exception;
    }

    public static interface TxConsumer {
        public void accept(KernelTransaction var1) throws Exception;
    }
}

