/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.utils;

import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.api.ValueConversion;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.Value;

public final class Neo4jValueConversion {
    public static long getLongValue(Value value) {
        if (value instanceof IntegralValue) {
            return ((IntegralValue)value).longValue();
        }
        if (value instanceof FloatingPointValue) {
            return ValueConversion.exactDoubleToLong((double)((FloatingPointValue)value).doubleValue());
        }
        throw Neo4jValueConversion.conversionError(value, "Long");
    }

    public static double getDoubleValue(Value value) {
        if (value instanceof FloatingPointValue) {
            return ((FloatingPointValue)value).doubleValue();
        }
        if (value instanceof IntegralValue) {
            return ValueConversion.exactLongToDouble((long)((IntegralValue)value).longValue());
        }
        throw Neo4jValueConversion.conversionError(value, "Double");
    }

    public static long[] getLongArray(Value value) {
        if (value instanceof LongArray) {
            return ((LongArray)value).asObjectCopy();
        }
        throw Neo4jValueConversion.conversionError(value, "Long Array");
    }

    public static double[] getDoubleArray(Value value) {
        if (value instanceof DoubleArray) {
            return ((DoubleArray)value).asObjectCopy();
        }
        if (value instanceof LongArray && ((LongArray)value).length() == 0) {
            return new double[0];
        }
        throw Neo4jValueConversion.conversionError(value, "Double Array");
    }

    public static float[] getFloatArray(Value value) {
        if (value instanceof FloatArray) {
            return ((FloatArray)value).asObjectCopy();
        }
        throw Neo4jValueConversion.conversionError(value, "Float Array");
    }

    @NotNull
    private static UnsupportedOperationException conversionError(Value value, String expected) {
        return new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Cannot safely convert %s into a %s", (Object[])new Object[]{value, expected}));
    }

    private Neo4jValueConversion() {
    }
}

