/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.text.CaseUtils;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.utils.CheckedRunnable;

public enum GdsFeatureToggles {
    SKIP_ORPHANS(false),
    USE_PROPERTY_VALUE_INDEX(false),
    USE_PARALLEL_PROPERTY_VALUE_INDEX(false),
    USE_PARTITIONED_SCAN(false),
    USE_BIT_ID_MAP(true),
    USE_SHARDED_ID_MAP(false),
    USE_UNCOMPRESSED_ADJACENCY_LIST(false),
    USE_REORDERED_ADJACENCY_LIST(false);

    private final AtomicBoolean current;
    private final boolean defaultValue;
    public static final int MAX_ARRAY_LENGTH_SHIFT_DEFAULT_SETTING = 28;
    private static final int MAX_ARRAY_LENGTH_SHIFT_FLAG;
    public static final AtomicInteger MAX_ARRAY_LENGTH_SHIFT;
    public static final int PAGES_PER_THREAD_DEFAULT_SETTING = 4;
    private static final int PAGES_PER_THREAD_FLAG;
    public static final AtomicInteger PAGES_PER_THREAD;

    public boolean isEnabled() {
        return this.current.get();
    }

    public boolean isDisabled() {
        return !this.isEnabled();
    }

    public boolean toggle(boolean value) {
        return this.current.getAndSet(value);
    }

    public void reset() {
        this.current.set(this.defaultValue);
    }

    @TestOnly
    public synchronized <E extends Exception> void enableAndRun(CheckedRunnable<E> code) throws E {
        boolean before = this.toggle(true);
        try {
            code.checkedRun();
        }
        finally {
            this.toggle(before);
        }
    }

    @TestOnly
    public synchronized <E extends Exception> void disableAndRun(CheckedRunnable<E> code) throws E {
        boolean before = this.toggle(false);
        try {
            code.checkedRun();
        }
        finally {
            this.toggle(before);
        }
    }

    private GdsFeatureToggles(boolean defaultValue) {
        this.defaultValue = defaultValue;
        this.current = new AtomicBoolean(GdsFeatureToggles.booleanProperty(GdsFeatureToggles.name(GdsFeatureToggles.class, CaseUtils.toCamelCase((String)this.name(), (boolean)false, (char[])new char[]{'_'})), defaultValue));
    }

    private static String name(Class<?> location, String name) {
        return location.getCanonicalName() + "." + name;
    }

    private static boolean booleanProperty(String flag, boolean defaultValue) {
        return GdsFeatureToggles.parseBoolean(System.getProperty(flag), defaultValue);
    }

    private static boolean parseBoolean(String value, boolean defaultValue) {
        return defaultValue ? !"false".equalsIgnoreCase(value) : "true".equalsIgnoreCase(value);
    }

    static {
        MAX_ARRAY_LENGTH_SHIFT_FLAG = Integer.getInteger(GdsFeatureToggles.name(GdsFeatureToggles.class, "maxArrayLengthShift"), 28);
        MAX_ARRAY_LENGTH_SHIFT = new AtomicInteger(MAX_ARRAY_LENGTH_SHIFT_FLAG);
        PAGES_PER_THREAD_FLAG = Integer.getInteger(GdsFeatureToggles.name(GdsFeatureToggles.class, "pagesPerThread"), 4);
        PAGES_PER_THREAD = new AtomicInteger(PAGES_PER_THREAD_FLAG);
    }
}

