/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.utils.CheckedConsumer;
import org.neo4j.gds.utils.CheckedFunction;
import org.neo4j.gds.utils.CheckedRunnable;
import org.neo4j.gds.utils.CheckedSupplier;
import org.neo4j.gds.utils.StringFormatting;

public final class ExceptionUtil {
    public static final CheckedConsumer<Exception, Exception> RETHROW_CHECKED = e -> {
        throw e;
    };
    public static final CheckedConsumer<Exception, RuntimeException> RETHROW_UNCHECKED = e -> {
        ExceptionUtil.throwIfUnchecked(e);
        throw new RuntimeException((Throwable)e);
    };

    public static Throwable rootCause(Throwable caughtException) {
        if (null == caughtException) {
            throw new IllegalArgumentException("Cannot obtain rootCause from (null)");
        }
        Throwable root = caughtException;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    @Contract(value="null, _ -> param2; !null, _ -> !null")
    @Nullable
    public static <T extends Throwable> T chain(@Nullable T initial, @Nullable T current) {
        if (initial == null) {
            return current;
        }
        if (current != null) {
            initial.addSuppressed(current);
        }
        return initial;
    }

    public static void closeAll(Stream<? extends AutoCloseable> closeables) throws Exception {
        ExceptionUtil.closeAll(closeables.iterator());
    }

    public static void closeAll(AutoCloseable ... closeables) throws Exception {
        ExceptionUtil.closeAll(Arrays.asList(closeables));
    }

    public static void closeAll(Iterable<? extends AutoCloseable> closeables) throws Exception {
        ExceptionUtil.closeAll(closeables.iterator());
    }

    public static void closeAll(Iterator<? extends AutoCloseable> closeables) throws Exception {
        ExceptionUtil.closeAll(RETHROW_CHECKED, closeables);
    }

    public static <E extends Exception> void closeAll(CheckedConsumer<Exception, E> handler, Stream<? extends AutoCloseable> closeables) throws E {
        ExceptionUtil.closeAll(handler, closeables.iterator());
    }

    public static <E extends Exception> void closeAll(CheckedConsumer<Exception, E> handler, AutoCloseable ... closeables) throws E {
        ExceptionUtil.closeAll(handler, Arrays.asList(closeables));
    }

    public static <E extends Exception> void closeAll(CheckedConsumer<Exception, E> handler, Iterable<? extends AutoCloseable> closeables) throws E {
        ExceptionUtil.closeAll(handler, closeables.iterator());
    }

    public static <E extends Exception> void closeAll(CheckedConsumer<Exception, E> handler, Iterator<? extends AutoCloseable> closeables) throws E {
        Exception error = null;
        while (closeables.hasNext()) {
            AutoCloseable closeable = closeables.next();
            try {
                closeable.close();
            }
            catch (Exception e) {
                error = ExceptionUtil.chain(error, e);
            }
        }
        if (error != null) {
            handler.checkedAccept(error);
        }
    }

    public static void throwIfUnchecked(Throwable exception) {
        Objects.requireNonNull(exception);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof IOException) {
            throw new UncheckedIOException((IOException)exception);
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
    }

    public static <E extends Exception> Runnable unchecked(CheckedRunnable<E> runnable) {
        return runnable;
    }

    public static <E extends Exception> void run(CheckedRunnable<E> runnable) {
        runnable.run();
    }

    public static <T, E extends Exception> Consumer<T> consumer(CheckedConsumer<T, E> consumer) {
        return consumer;
    }

    public static <T, R, E extends Exception> Function<T, R> function(CheckedFunction<T, R, E> function) {
        return function;
    }

    public static <T, E extends Exception> Supplier<? extends T> supplier(CheckedSupplier<? extends T, E> supplier) {
        return supplier;
    }

    public static <T, E extends Exception> T supply(CheckedSupplier<? extends T, E> supplier) {
        return supplier.get();
    }

    public static <T, R, E extends Exception> R apply(CheckedFunction<? super T, ? extends R, E> function, T input) {
        return function.apply(input);
    }

    public static void validateTargetNodeIsLoaded(long mappedId, long neoId) {
        ExceptionUtil.validateNodeIsLoaded(mappedId, neoId, "target");
    }

    public static void validateSourceNodeIsLoaded(long mappedId, long neoId) {
        ExceptionUtil.validateNodeIsLoaded(mappedId, neoId, "source");
    }

    private static void validateNodeIsLoaded(long mappedId, long neoId, String side) {
        if (mappedId == -1L) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Failed to load a relationship because its %s-node with id %s is not part of the node query or projection. To ignore the relationship, set the configuration parameter `validateRelationships` to false.", (Object[])new Object[]{side, neoId}));
        }
    }

    private ExceptionUtil() {
        throw new UnsupportedOperationException("No instances");
    }
}

