/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.utils;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;

public class CloseableThreadLocal<T>
implements Closeable {
    private final Supplier<T> initialValueSupplier;
    protected ThreadLocal<WeakReference<T>> t = new ThreadLocal();
    Map<Thread, T> hardRefs = new WeakHashMap<Thread, T>();

    public static <T> CloseableThreadLocal<T> withInitial(Supplier<T> initialValueSupplier) {
        return new CloseableThreadLocal<T>(initialValueSupplier);
    }

    public CloseableThreadLocal(Supplier<T> constructor) {
        this.initialValueSupplier = constructor;
    }

    protected T initialValue() {
        return this.initialValueSupplier.get();
    }

    public T get() {
        WeakReference<T> weakRef = this.t.get();
        if (weakRef == null) {
            T iv = this.initialValue();
            if (iv != null) {
                this.set(iv);
                return iv;
            }
            return null;
        }
        return weakRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T object) {
        this.t.set(new WeakReference<T>(object));
        Map<Thread, T> map = this.hardRefs;
        synchronized (map) {
            this.hardRefs.put(Thread.currentThread(), object);
        }
    }

    @Override
    public void close() {
        this.hardRefs = null;
        if (this.t != null) {
            this.t.remove();
        }
        this.t = null;
    }
}

