/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.utils;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.immutables.builder.Builder;
import org.neo4j.gds.utils.CheckedSupplier;
import org.neo4j.gds.utils.CloseableThreadLocal;
import org.neo4j.gds.utils.ExceptionUtil;

public final class AutoCloseableThreadLocal<T extends AutoCloseable>
implements Supplier<T>,
AutoCloseable {
    private final CloseableThreadLocal<T> closeableThreadLocal;
    private final Consumer<? super T> destructor;
    private final Set<T> copies;

    public static <T extends AutoCloseable> AutoCloseableThreadLocal<T> withInitial(CheckedSupplier<T, ?> initial) {
        return new AutoCloseableThreadLocal<T>(initial, Optional.empty());
    }

    @Builder.Constructor
    public AutoCloseableThreadLocal(@Builder.Parameter Supplier<T> constructor, Optional<Consumer<? super T>> destructor) {
        this.destructor = destructor.orElse(doNothing -> {});
        this.copies = Collections.newSetFromMap(new ConcurrentHashMap());
        this.closeableThreadLocal = CloseableThreadLocal.withInitial(() -> {
            AutoCloseable newElement = (AutoCloseable)constructor.get();
            this.copies.add(newElement);
            return newElement;
        });
    }

    @Override
    public T get() {
        return (T)((AutoCloseable)this.closeableThreadLocal.get());
    }

    public void forEach(Consumer<T> consumer) {
        this.copies.forEach(consumer);
    }

    @Override
    public void close() {
        AtomicReference error = new AtomicReference();
        this.copies.removeIf(item -> {
            try (AutoCloseable autoCloseable = item;){
                this.destructor.accept((AutoCloseable)item);
            }
            catch (RuntimeException e) {
                error.set(ExceptionUtil.chain((RuntimeException)error.get(), e));
            }
            catch (Exception e) {
                error.set(ExceptionUtil.chain((RuntimeException)error.get(), new RuntimeException(e)));
            }
            return true;
        });
        this.closeableThreadLocal.close();
        RuntimeException errorWhileClosing = (RuntimeException)error.get();
        if (errorWhileClosing != null) {
            throw errorWhileClosing;
        }
    }
}

