/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.function.LongUnaryOperator;
import java.util.stream.Stream;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.Relationship;
import org.neo4j.gds.core.write.RelationshipStreamExporter;

public abstract class RelationshipStreamExporterBuilder<T extends RelationshipStreamExporter> {
    protected Stream<Relationship> relationships;
    protected int batchSize = 10000;
    protected LongUnaryOperator toOriginalId;
    protected TerminationFlag terminationFlag;
    protected ProgressTracker progressTracker = ProgressTracker.NULL_TRACKER;

    public abstract T build();

    public RelationshipStreamExporterBuilder<T> withIdMappingOperator(LongUnaryOperator toOriginalNodeId) {
        this.toOriginalId = toOriginalNodeId;
        return this;
    }

    public RelationshipStreamExporterBuilder<T> withTerminationFlag(TerminationFlag terminationFlag) {
        this.terminationFlag = terminationFlag;
        return this;
    }

    public RelationshipStreamExporterBuilder<T> withRelationships(Stream<Relationship> relationships) {
        this.relationships = relationships;
        return this;
    }

    @TestOnly
    public RelationshipStreamExporterBuilder<T> withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public RelationshipStreamExporterBuilder<T> withProgressTracker(ProgressTracker progressTracker) {
        this.progressTracker = progressTracker;
        return this;
    }
}

