/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.LongUnaryOperator;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.NodePropertyExporter;

public abstract class NodePropertyExporterBuilder<T extends NodePropertyExporter> {
    protected LongUnaryOperator toOriginalId;
    protected long nodeCount;
    protected TerminationFlag terminationFlag;
    protected ExecutorService executorService;
    protected int writeConcurrency = 4;
    protected ProgressTracker progressTracker = ProgressTracker.NULL_TRACKER;

    public abstract T build();

    public NodePropertyExporterBuilder<T> withIdMap(IdMap idMap) {
        Objects.requireNonNull(idMap);
        this.nodeCount = idMap.nodeCount();
        this.toOriginalId = idMap::toOriginalNodeId;
        return this;
    }

    public NodePropertyExporterBuilder<T> withTerminationFlag(TerminationFlag terminationFlag) {
        this.terminationFlag = terminationFlag;
        return this;
    }

    public NodePropertyExporterBuilder<T> withProgressTracker(ProgressTracker progressTracker) {
        this.progressTracker = progressTracker;
        return this;
    }

    public NodePropertyExporterBuilder<T> parallel(ExecutorService es, int writeConcurrency) {
        this.executorService = es;
        this.writeConcurrency = writeConcurrency;
        return this;
    }
}

