/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.LongUnaryOperator;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.NativeRelationshipExporterBuilder;
import org.neo4j.gds.core.write.RelationshipExporter;
import org.neo4j.gds.core.write.RelationshipExporterBuilder;
import org.neo4j.gds.core.write.RelationshipPropertyTranslator;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.ExceptionUtil;
import org.neo4j.gds.utils.StatementApi;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;

public final class NativeRelationshipExporter
extends StatementApi
implements RelationshipExporter {
    private final Graph graph;
    private final LongUnaryOperator toOriginalId;
    private final RelationshipPropertyTranslator propertyTranslator;
    private final TerminationFlag terminationFlag;
    private final ProgressTracker progressTracker;
    private final ExecutorService executorService;

    public static RelationshipExporterBuilder<NativeRelationshipExporter> builder(TransactionContext transactionContext, Graph graph, TerminationFlag terminationFlag) {
        return NativeRelationshipExporter.builder(transactionContext, graph, graph, terminationFlag);
    }

    public static RelationshipExporterBuilder<NativeRelationshipExporter> builder(TransactionContext transactionContext, IdMap idMap, Graph graph, TerminationFlag terminationFlag) {
        return new NativeRelationshipExporterBuilder(transactionContext).withGraph(graph).withIdMappingOperator(idMap::toOriginalNodeId).withTerminationFlag(terminationFlag);
    }

    NativeRelationshipExporter(TransactionContext transactionContext, Graph graph, LongUnaryOperator toOriginalId, RelationshipPropertyTranslator propertyTranslator, TerminationFlag terminationFlag, ProgressTracker progressTracker) {
        super(transactionContext);
        this.graph = graph;
        this.toOriginalId = toOriginalId;
        this.propertyTranslator = propertyTranslator;
        this.terminationFlag = terminationFlag;
        this.progressTracker = progressTracker;
        this.executorService = Pools.DEFAULT_SINGLE_THREAD_POOL;
    }

    @Override
    public void write(String relationshipType) {
        int relationshipToken = this.getOrCreateRelationshipToken(relationshipType);
        this.write(relationshipToken, -1, null);
    }

    @Override
    public void write(String relationshipType, String propertyKey) {
        int relationshipTypeToken = this.getOrCreateRelationshipToken(relationshipType);
        int propertyKeyToken = this.getOrCreatePropertyToken(propertyKey);
        this.write(relationshipTypeToken, propertyKeyToken, null);
    }

    @Override
    public void write(String relationshipType, String propertyKey, @Nullable RelationshipWithPropertyConsumer afterWriteConsumer) {
        int relationshipTypeToken = this.getOrCreateRelationshipToken(relationshipType);
        int propertyKeyToken = this.getOrCreatePropertyToken(propertyKey);
        this.write(relationshipTypeToken, propertyKeyToken, afterWriteConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(int relationshipTypeToken, int propertyKeyToken, @Nullable RelationshipWithPropertyConsumer afterWriteConsumer) {
        List<Runnable> tasks = PartitionUtils.degreePartitionWithBatchSize(this.graph, 10000L, partition -> this.createBatchRunnable(relationshipTypeToken, propertyKeyToken, (Partition)partition, afterWriteConsumer));
        this.progressTracker.beginSubTask();
        try {
            tasks.forEach(runnable -> ParallelUtil.run(runnable, this.executorService));
        }
        finally {
            this.progressTracker.endSubTask();
        }
    }

    private Runnable createBatchRunnable(int relationshipToken, int propertyToken, Partition partition, @Nullable RelationshipWithPropertyConsumer afterWrite) {
        return () -> this.acceptInTransaction(stmt -> {
            this.terminationFlag.assertRunning();
            Write ops = stmt.dataWrite();
            RelationshipWithPropertyConsumer writeConsumer = new WriteConsumer(this.toOriginalId, ops, this.propertyTranslator, relationshipToken, propertyToken, this.progressTracker);
            if (afterWrite != null) {
                writeConsumer = writeConsumer.andThen(afterWrite);
            }
            Graph relationshipIterator = this.graph.concurrentCopy();
            RelationshipWithPropertyConsumer finalWriteConsumer = writeConsumer;
            long startNode = partition.startNode();
            partition.consume(nodeId -> {
                relationshipIterator.forEachRelationship(nodeId, Double.NaN, finalWriteConsumer);
                if ((nodeId - startNode) % 10000L == 0L) {
                    this.terminationFlag.assertRunning();
                }
            });
        });
    }

    private static class WriteConsumer
    implements RelationshipWithPropertyConsumer {
        private final LongUnaryOperator toOriginalId;
        private final Write ops;
        private final RelationshipPropertyTranslator propertyTranslator;
        private final int relTypeToken;
        private final int propertyToken;
        private final ProgressTracker progressTracker;
        private final RelationshipWriteBehavior relationshipWriteBehavior;

        WriteConsumer(LongUnaryOperator toOriginalId, Write ops, RelationshipPropertyTranslator propertyTranslator, int relTypeToken, int propertyToken, ProgressTracker progressTracker) {
            this.toOriginalId = toOriginalId;
            this.ops = ops;
            this.propertyTranslator = propertyTranslator;
            this.relTypeToken = relTypeToken;
            this.propertyToken = propertyToken;
            this.progressTracker = progressTracker;
            this.relationshipWriteBehavior = propertyToken == -1 ? this::writeWithoutProperty : this::writeWithProperty;
        }

        @Override
        public boolean accept(long sourceNodeId, long targetNodeId, double property) {
            try {
                this.relationshipWriteBehavior.apply(sourceNodeId, targetNodeId, property);
                return true;
            }
            catch (Exception e) {
                ExceptionUtil.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }

        private void writeWithoutProperty(long sourceNodeId, long targetNodeId, double property) throws EntityNotFoundException {
            this.writeRelationship(sourceNodeId, targetNodeId);
            this.progressTracker.logProgress();
        }

        private void writeWithProperty(long sourceNodeId, long targetNodeId, double property) throws EntityNotFoundException {
            long relId = this.writeRelationship(sourceNodeId, targetNodeId);
            this.exportProperty(property, relId);
            this.progressTracker.logProgress();
        }

        private long writeRelationship(long sourceNodeId, long targetNodeId) throws EntityNotFoundException {
            return this.ops.relationshipCreate(this.toOriginalId.applyAsLong(sourceNodeId), this.relTypeToken, this.toOriginalId.applyAsLong(targetNodeId));
        }

        private void exportProperty(double property, long relId) throws EntityNotFoundException {
            if (!Double.isNaN(property)) {
                this.ops.relationshipSetProperty(relId, this.propertyToken, this.propertyTranslator.toValue(property));
            }
        }

        @FunctionalInterface
        static interface RelationshipWriteBehavior {
            public void apply(long var1, long var3, double var5) throws EntityNotFoundException;
        }
    }
}

