/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.LazyBatchCollection;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.ImmutableNodeProperty;
import org.neo4j.gds.core.write.ImmutableResolvedNodeProperty;
import org.neo4j.gds.core.write.NativeNodePropertiesExporterBuilder;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.StatementApi;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.values.storable.Value;

public class NativeNodePropertyExporter
extends StatementApi
implements NodePropertyExporter {
    protected final TerminationFlag terminationFlag;
    protected final ExecutorService executorService;
    protected final ProgressTracker progressTracker;
    protected final int concurrency;
    protected final long nodeCount;
    protected final LongUnaryOperator toOriginalId;
    protected final LongAdder propertiesWritten;

    public static NodePropertyExporterBuilder<NativeNodePropertyExporter> builder(TransactionContext transactionContext, IdMap idMap, TerminationFlag terminationFlag) {
        return new NativeNodePropertiesExporterBuilder(transactionContext).withIdMap(idMap).withTerminationFlag(terminationFlag);
    }

    protected NativeNodePropertyExporter(TransactionContext tx, long nodeCount, LongUnaryOperator toOriginalId, TerminationFlag terminationFlag, ProgressTracker progressTracker, int concurrency, ExecutorService executorService) {
        super(tx);
        this.nodeCount = nodeCount;
        this.toOriginalId = toOriginalId;
        this.terminationFlag = terminationFlag;
        this.progressTracker = progressTracker;
        this.concurrency = concurrency;
        this.executorService = executorService;
        this.propertiesWritten = new LongAdder();
    }

    @Override
    public void write(String property, NodePropertyValues properties) {
        this.write(ImmutableNodeProperty.of(property, properties));
    }

    @Override
    public void write(NodeProperty nodeProperty) {
        this.write(List.of(nodeProperty));
    }

    @Override
    public void write(Collection<NodeProperty> nodeProperties) {
        List<ResolvedNodeProperty> resolvedNodeProperties = nodeProperties.stream().map(desc -> desc.resolveWith(this.getOrCreatePropertyToken(desc.propertyKey()))).collect(Collectors.toList());
        this.progressTracker.beginSubTask(this.nodeCount);
        try {
            if (ParallelUtil.canRunInParallel(this.executorService)) {
                this.writeParallel(resolvedNodeProperties);
            } else {
                this.writeSequential(resolvedNodeProperties);
            }
        }
        finally {
            this.progressTracker.endSubTask();
        }
    }

    @Override
    public long propertiesWritten() {
        return this.propertiesWritten.longValue();
    }

    private void writeSequential(Iterable<ResolvedNodeProperty> nodeProperties) {
        this.writeSequential((Write ops, long nodeId) -> this.doWrite(nodeProperties, ops, nodeId));
    }

    private void writeParallel(Iterable<ResolvedNodeProperty> nodeProperties) {
        this.writeParallel((Write ops, long offset) -> this.doWrite(nodeProperties, ops, offset));
    }

    private void doWrite(Iterable<ResolvedNodeProperty> nodeProperties, Write ops, long nodeId) throws Exception {
        for (ResolvedNodeProperty nodeProperty : nodeProperties) {
            int propertyId = nodeProperty.propertyToken();
            Value prop = nodeProperty.properties().value(nodeId);
            if (prop == null) continue;
            ops.nodeSetProperty(this.toOriginalId.applyAsLong(nodeId), propertyId, prop);
            this.propertiesWritten.increment();
        }
    }

    private void writeSequential(WriteConsumer writer) {
        this.acceptInTransaction(stmt -> {
            this.terminationFlag.assertRunning();
            long progress = 0L;
            Write ops = stmt.dataWrite();
            for (long i = 0L; i < this.nodeCount; ++i) {
                writer.accept(ops, i);
                this.progressTracker.logProgress();
                if (++progress % 10000L != 0L) continue;
                this.terminationFlag.assertRunning();
            }
        });
    }

    private void writeParallel(WriteConsumer writer) {
        long batchSize = ParallelUtil.adjustedBatchSize(this.nodeCount, this.concurrency, 10000L, 100000L);
        Collection<Runnable> runnables = LazyBatchCollection.of(this.nodeCount, batchSize, (start, len) -> () -> this.acceptInTransaction(stmt -> {
            this.terminationFlag.assertRunning();
            long end = start + len;
            Write ops = stmt.dataWrite();
            for (long currentNode = start; currentNode < end; ++currentNode) {
                writer.accept(ops, currentNode);
                this.progressTracker.logProgress();
                if ((currentNode - start) % 10000L != 0L) continue;
                this.terminationFlag.assertRunning();
            }
        }));
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks(runnables).maxWaitRetries(Integer.MAX_VALUE).waitTime(10L, TimeUnit.MICROSECONDS).terminationFlag(this.terminationFlag).executor(this.executorService).mayInterruptIfRunning(false).run();
    }

    public static interface WriteConsumer {
        public void accept(Write var1, long var2) throws Exception;
    }

    @ValueClass
    public static interface ResolvedNodeProperty
    extends NodeProperty {
        public int propertyToken();

        public static ResolvedNodeProperty of(NodeProperty nodeProperty, int propertyToken) {
            return ImmutableResolvedNodeProperty.of(nodeProperty.propertyKey(), nodeProperty.properties(), propertyToken);
        }
    }
}

