/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.write;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.write.Relationship;
import org.neo4j.values.storable.Value;

@ParametersAreNonnullByDefault
@Generated(from="Relationship", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableRelationship
implements Relationship {
    private final long sourceNode;
    private final long targetNode;
    private final Value[] values;

    private ImmutableRelationship(long sourceNode, long targetNode, Value[] values) {
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.values = (Value[])values.clone();
    }

    private ImmutableRelationship(ImmutableRelationship original, long sourceNode, long targetNode, Value[] values) {
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.values = values;
    }

    @Override
    public long sourceNode() {
        return this.sourceNode;
    }

    @Override
    public long targetNode() {
        return this.targetNode;
    }

    @Override
    public Value[] values() {
        return (Value[])this.values.clone();
    }

    public final ImmutableRelationship withSourceNode(long value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableRelationship(this, value, this.targetNode, this.values);
    }

    public final ImmutableRelationship withTargetNode(long value) {
        if (this.targetNode == value) {
            return this;
        }
        return new ImmutableRelationship(this, this.sourceNode, value, this.values);
    }

    public final ImmutableRelationship withValues(Value ... elements) {
        Value[] newValue = (Value[])elements.clone();
        return new ImmutableRelationship(this, this.sourceNode, this.targetNode, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationship && this.equalTo((ImmutableRelationship)another);
    }

    private boolean equalTo(ImmutableRelationship another) {
        return this.sourceNode == another.sourceNode && this.targetNode == another.targetNode && Arrays.equals(this.values, another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.sourceNode);
        h += (h << 5) + Long.hashCode(this.targetNode);
        h += (h << 5) + Arrays.hashCode(this.values);
        return h;
    }

    public String toString() {
        return "Relationship{sourceNode=" + this.sourceNode + ", targetNode=" + this.targetNode + ", values=" + Arrays.toString(this.values) + "}";
    }

    public static Relationship of(long sourceNode, long targetNode, Value[] values) {
        return new ImmutableRelationship(sourceNode, targetNode, values);
    }

    public static Relationship copyOf(Relationship instance) {
        if (instance instanceof ImmutableRelationship) {
            return (ImmutableRelationship)instance;
        }
        return ImmutableRelationship.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Relationship", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_NODE = 1L;
        private static final long INIT_BIT_TARGET_NODE = 2L;
        private static final long INIT_BIT_VALUES = 4L;
        private long initBits = 7L;
        private long sourceNode;
        private long targetNode;
        @Nullable
        private Value[] values;

        private Builder() {
        }

        public final Builder from(Relationship instance) {
            Objects.requireNonNull(instance, "instance");
            this.sourceNode(instance.sourceNode());
            this.targetNode(instance.targetNode());
            this.values(instance.values());
            return this;
        }

        public final Builder sourceNode(long sourceNode) {
            this.sourceNode = sourceNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder targetNode(long targetNode) {
            this.targetNode = targetNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder values(Value ... values) {
            this.values = (Value[])values.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.sourceNode = 0L;
            this.targetNode = 0L;
            this.values = null;
            return this;
        }

        public Relationship build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelationship(null, this.sourceNode, this.targetNode, this.values);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceNode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetNode");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("values");
            }
            return "Cannot build Relationship, some of required attributes are not set " + attributes;
        }
    }
}

