/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.warnings;

import java.util.function.Supplier;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.configuration.Config;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.gds.core.utils.progress.ProgressFeatureSettings;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogStore;
import org.neo4j.gds.core.utils.warnings.GlobalUserLogStore;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogStore;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.internal.LogService;

public class UserLogRegistryExtension
extends ExtensionFactory<Dependencies> {
    private final Supplier<GlobalUserLogStore> userLogStoreSupplier;

    public UserLogRegistryExtension() {
        super(ExtensionType.DATABASE, "gds.warnings.registry");
        this.userLogStoreSupplier = GlobalUserLogStore::new;
    }

    @TestOnly
    public UserLogRegistryExtension(Supplier<GlobalUserLogStore> userLogStoreSupplier) {
        super(ExtensionType.DATABASE, "gds.warnings.registry");
        this.userLogStoreSupplier = userLogStoreSupplier;
    }

    public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
        GlobalProcedures registry = dependencies.globalProceduresRegistry();
        Boolean enabled = (Boolean)dependencies.config().get(ProgressFeatureSettings.progress_tracking_enabled);
        if (enabled.booleanValue()) {
            GlobalUserLogStore globalWarningStore = this.userLogStoreSupplier.get();
            registry.registerComponent(UserLogStore.class, ctx -> globalWarningStore, true);
            registry.registerComponent(UserLogRegistryFactory.class, (ThrowingFunction)globalWarningStore, true);
        } else {
            registry.registerComponent(UserLogRegistryFactory.class, ctx -> EmptyUserLogRegistryFactory.INSTANCE, true);
            registry.registerComponent(UserLogStore.class, ctx -> EmptyUserLogStore.INSTANCE, true);
        }
        return new LifecycleAdapter();
    }

    static interface Dependencies {
        public Config config();

        public LogService logService();

        public GlobalProcedures globalProceduresRegistry();
    }
}

