/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.statistics;

import java.util.Random;

public final class DistributionHelper {
    private DistributionHelper() {
    }

    public static long uniformSample(long upperBound, Random random) {
        return (random.nextLong() & Long.MAX_VALUE) % upperBound;
    }

    public static long gaussianSample(long upperBound, long mean, long stdDev, Random random) {
        double gaussian = random.nextGaussian() * (double)stdDev + (double)(mean % upperBound);
        return Math.round(gaussian);
    }

    public static long powerLawSample(long min, long max, double gamma, Random random) {
        double maxGamma = Math.pow(max, -gamma + 1.0);
        double minGamma = Math.pow(min, -gamma + 1.0);
        double base = (maxGamma - minGamma) * random.nextDouble() + minGamma;
        double exponent = 1.0 / (-gamma + 1.0);
        return Math.round(Math.pow(base, exponent));
    }
}

