/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.queue;

import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.utils.TerminationFlag;

public class QueueBasedSpliterator<T>
implements Spliterator<T> {
    private final BlockingQueue<T> queue;
    private final T tombstone;
    @Nullable
    private T entry;
    private final TerminationFlag terminationGuard;
    private final int timeoutInSeconds;

    public QueueBasedSpliterator(BlockingQueue<T> queue, T tombstone, TerminationFlag terminationGuard, int timeoutInSeconds) {
        this.queue = queue;
        this.tombstone = tombstone;
        this.terminationGuard = terminationGuard;
        this.timeoutInSeconds = timeoutInSeconds;
        this.entry = this.poll();
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.isEnd()) {
            return false;
        }
        this.terminationGuard.assertRunning();
        action.accept(this.entry);
        this.entry = this.poll();
        return !this.isEnd();
    }

    private boolean isEnd() {
        return this.entry == null || this.entry == this.tombstone;
    }

    @Nullable
    private T poll() {
        try {
            return this.queue.poll(this.timeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 256;
    }
}

